/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.entity.shooter;

import com.imguns.guns.api.LogicalSide;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.event.common.GunDrawEvent;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.entity.shooter.ShooterDataHolder;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.event.ServerMessageGunDraw;
import com.imguns.guns.resource.index.CommonGunIndex;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class LivingEntityDrawGun {
    private final class_1309 shooter;
    private final ShooterDataHolder data;

    public LivingEntityDrawGun(class_1309 shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void draw(Supplier<class_1799> gunItemSupplier) {
        long drawTime;
        this.data.initialData();
        if (this.data.drawTimestamp == -1L) {
            this.data.drawTimestamp = System.currentTimeMillis();
        }
        if ((drawTime = System.currentTimeMillis() - this.data.drawTimestamp) >= 0L) {
            this.data.drawTimestamp = (float)drawTime < this.data.currentPutAwayTimeS * 1000.0f ? System.currentTimeMillis() + drawTime : System.currentTimeMillis() + (long)(this.data.currentPutAwayTimeS * 1000.0f);
        }
        class_1799 lastItem = this.data.currentGunItem == null ? class_1799.field_8037 : this.data.currentGunItem.get();
        new GunDrawEvent(this.shooter, lastItem, gunItemSupplier.get(), LogicalSide.SERVER).post();
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunDraw(this.shooter.method_5628(), lastItem, gunItemSupplier.get()), (class_1297)this.shooter);
        this.data.currentGunItem = gunItemSupplier;
        this.updatePutAwayTime();
    }

    public long getDrawCoolDown() {
        if (this.data.currentGunItem == null) {
            return 0L;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return 0L;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndex.map(index -> {
            long coolDown = (long)(index.getGunData().getDrawTime() * 1000.0f) - (System.currentTimeMillis() - this.data.drawTimestamp);
            if ((coolDown -= 5L) < 0L) {
                return 0L;
            }
            return coolDown;
        }).orElse(-1L);
    }

    private void updatePutAwayTime() {
        class_1799 gunItem = this.data.currentGunItem == null ? class_1799.field_8037 : this.data.currentGunItem.get();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem));
            this.data.currentPutAwayTimeS = gunIndex.map(index -> Float.valueOf(index.getGunData().getPutAwayTime())).orElse(Float.valueOf(0.0f)).floatValue();
        } else {
            this.data.currentPutAwayTimeS = 0.0f;
        }
    }
}

