/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.entity.shooter;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.LogicalSide;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.entity.IGunOperator;
import com.imguns.guns.api.entity.ReloadState;
import com.imguns.guns.api.event.common.GunReloadEvent;
import com.imguns.guns.api.item.IAmmo;
import com.imguns.guns.api.item.IAmmoBox;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.gun.AbstractGunItem;
import com.imguns.guns.entity.shooter.LivingEntityDrawGun;
import com.imguns.guns.entity.shooter.LivingEntityShoot;
import com.imguns.guns.entity.shooter.ShooterDataHolder;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.event.ServerMessageGunReload;
import com.imguns.guns.resource.index.CommonGunIndex;
import com.imguns.guns.resource.pojo.data.gun.Bolt;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.resource.pojo.data.gun.GunReloadData;
import com.imguns.guns.util.AttachmentDataUtils;
import com.imguns.guns.util.item.IItemHandler;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class LivingEntityReload {
    private final class_1309 shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityReload(class_1309 shooter, ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void reload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.boltCoolDown >= 0L) {
                return;
            }
            int currentAmmoCount = iGun.getCurrentAmmoCount(currentGunItem);
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(currentGunItem, gunIndex.getGunData());
            if (IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo() && !LivingEntityReload.inventoryHasAmmo(this.shooter, currentAmmoCount, maxAmmoCount, currentGunItem, iGun)) {
                return;
            }
            if (new GunReloadEvent(this.shooter, currentGunItem, LogicalSide.SERVER).post()) {
                return;
            }
            NetworkHandler.sendToTrackingEntity(new ServerMessageGunReload(this.shooter.method_5628(), currentGunItem), (class_1297)this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = iGun.getCurrentAmmoCount(currentGunItem) + (iGun.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            this.data.reloadStateType = ammoCount <= 0 ? ReloadState.StateType.EMPTY_RELOAD_FEEDING : ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
            this.data.reloadTimestamp = System.currentTimeMillis();
        });
    }

    public ReloadState tickReloadState() {
        AbstractGunItem abstractGunItem;
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(ReloadState.StateType.NOT_RELOADING);
        reloadState.setCountDown(-1L);
        if (this.data.reloadTimestamp == -1L || this.data.currentGunItem == null) {
            return reloadState;
        }
        class_1792 class_17922 = this.data.currentGunItem.get().method_7909();
        if (!(class_17922 instanceof IGun)) {
            return reloadState;
        }
        IGun iGun = (IGun)class_17922;
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_2960 gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return reloadState;
        }
        GunData gunData = gunIndexOptional.get().getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        long countDown = -1L;
        ReloadState.StateType stateType = this.data.reloadStateType;
        long progressTime = System.currentTimeMillis() - this.data.reloadTimestamp;
        if (stateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        } else if (stateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(currentGunItem, gunData);
        if (this.data.reloadStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && stateType == ReloadState.StateType.EMPTY_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.reloadAmmo(currentGunItem, LivingEntityReload.getAndExtractNeedAmmoCount(this.shooter, this.data.currentGunItem.get(), iGun, maxAmmoCount), true);
            }
        }
        if (this.data.reloadStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && stateType == ReloadState.StateType.TACTICAL_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.reloadAmmo(currentGunItem, LivingEntityReload.getAndExtractNeedAmmoCount(this.shooter, this.data.currentGunItem.get(), iGun, maxAmmoCount), false);
            }
        }
        this.data.reloadStateType = stateType;
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }

    public static boolean inventoryHasAmmo(class_1309 shooter, int currentAmmoCount, int maxAmmoCount, class_1799 currentGunItem, IGun iGun) {
        if (currentAmmoCount >= maxAmmoCount) {
            return false;
        }
        if (iGun.useDummyAmmo(currentGunItem)) {
            return iGun.getDummyAmmoAmount(currentGunItem) > 0;
        }
        return shooter.imguns$getItemHandler(null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                class_1799 checkAmmoStack = cap.getStackInSlot(i);
                class_1792 patt0$temp = checkAmmoStack.method_7909();
                if (patt0$temp instanceof IAmmo && (iAmmo = (IAmmo)patt0$temp).isAmmoOfGun(currentGunItem, checkAmmoStack)) {
                    return true;
                }
                class_1792 patt1$temp = checkAmmoStack.method_7909();
                if (!(patt1$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt1$temp).isAmmoBoxOfGun(currentGunItem, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static int getAndExtractNeedAmmoCount(class_1309 shooter, class_1799 currentGunItem, IGun iGun, int maxAmmoCount) {
        int currentAmmoCount = iGun.getCurrentAmmoCount(currentGunItem);
        if (IGunOperator.fromLivingEntity(shooter).needCheckAmmo()) {
            if (iGun.useDummyAmmo(currentGunItem)) {
                return LivingEntityReload.getAndExtractDummyAmmoCount(maxAmmoCount, currentAmmoCount, currentGunItem, iGun);
            }
            return shooter.imguns$getItemHandler(null).map(cap -> LivingEntityReload.getAndExtractInventoryAmmoCount(cap, maxAmmoCount, currentAmmoCount, currentGunItem)).orElse(currentAmmoCount);
        }
        return maxAmmoCount;
    }

    private static int getAndExtractDummyAmmoCount(int maxAmmoCount, int currentAmmoCount, class_1799 currentGunItem, IGun iGun) {
        int needAmmoCount = maxAmmoCount - currentAmmoCount;
        int dummyAmmoCount = iGun.getDummyAmmoAmount(currentGunItem);
        int extractCount = Math.min(dummyAmmoCount, needAmmoCount);
        iGun.setDummyAmmoAmount(currentGunItem, dummyAmmoCount - extractCount);
        return maxAmmoCount - (needAmmoCount - extractCount);
    }

    private static int getAndExtractInventoryAmmoCount(IItemHandler itemHandler, int maxAmmoCount, int currentAmmoCount, class_1799 currentGunItem) {
        class_1792 extractItem;
        IAmmo iAmmo;
        class_1799 checkAmmoStack;
        class_1792 class_17922;
        int needAmmoCount = maxAmmoCount - currentAmmoCount;
        for (int i = 0; !(i >= itemHandler.getSlots() || (class_17922 = (checkAmmoStack = itemHandler.getStackInSlot(i)).method_7909()) instanceof IAmmo && (iAmmo = (IAmmo)class_17922).isAmmoOfGun(currentGunItem, checkAmmoStack) && (needAmmoCount -= (extractItem = itemHandler.extractItem(i, needAmmoCount, false)).method_7947()) <= 0); ++i) {
            IAmmoBox iAmmoBox;
            extractItem = checkAmmoStack.method_7909();
            if (!(extractItem instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)extractItem).isAmmoBoxOfGun(currentGunItem, checkAmmoStack)) continue;
            int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
            int extractCount = Math.min(boxAmmoCount, needAmmoCount);
            int remainCount = boxAmmoCount - extractCount;
            iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
            if (remainCount <= 0) {
                iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
            }
            if ((needAmmoCount -= extractCount) <= 0) break;
        }
        return maxAmmoCount - needAmmoCount;
    }
}

