/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.entity.sync.core;

import com.google.common.collect.ImmutableSet;
import com.imguns.guns.GunMod;
import com.imguns.guns.entity.sync.core.DataHolder;
import com.imguns.guns.entity.sync.core.DataHolderCapabilityProvider;
import com.imguns.guns.entity.sync.core.SyncedClassKey;
import com.imguns.guns.entity.sync.core.SyncedDataKey;
import com.imguns.guns.init.CommonRegistry;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SyncedEntityData {
    private static final Marker SYNCED_ENTITY_DATA_MARKER = MarkerFactory.getMarker((String)"SYNCED_ENTITY_DATA_TAC_COPY");
    private static SyncedEntityData INSTANCE;
    private final Set<SyncedClassKey<?>> registeredClassKeys = new HashSet();
    private final Object2ObjectMap<class_2960, SyncedClassKey<?>> idToClassKey = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, SyncedClassKey<?>> classNameToClassKey = new Object2ObjectOpenHashMap();
    private final Object2BooleanMap<String> clientClassNameCapabilityCache = new Object2BooleanOpenHashMap();
    private final Object2BooleanMap<String> serverClassNameCapabilityCache = new Object2BooleanOpenHashMap();
    private final Set<SyncedDataKey<?, ?>> registeredDataKeys = new HashSet();
    private final Reference2ObjectMap<SyncedClassKey<?>, HashMap<class_2960, SyncedDataKey<?, ?>>> classToKeys = new Reference2ObjectOpenHashMap();
    private final Reference2IntMap<SyncedDataKey<?, ?>> internalIds = new Reference2IntOpenHashMap();
    private final Int2ReferenceMap<SyncedDataKey<?, ?>> syncedIdToKey = new Int2ReferenceOpenHashMap();
    private final AtomicInteger nextIdTracker = new AtomicInteger();
    private final List<class_1297> dirtyEntities = new ArrayList<class_1297>();
    private boolean dirty = false;

    private SyncedEntityData() {
    }

    public static SyncedEntityData instance() {
        if (INSTANCE == null) {
            INSTANCE = new SyncedEntityData();
        }
        return INSTANCE;
    }

    private <E extends class_1297> void registerClassKey(SyncedClassKey<E> classKey) {
        if (!this.registeredClassKeys.contains(classKey)) {
            this.registeredClassKeys.add(classKey);
            this.idToClassKey.put((Object)classKey.id(), classKey);
            this.classNameToClassKey.put((Object)classKey.entityClass().getName(), classKey);
        }
    }

    public synchronized <E extends class_1297, T> void registerDataKey(SyncedDataKey<E, T> dataKey) {
        class_2960 keyId = dataKey.id();
        SyncedClassKey<E> classKey = dataKey.classKey();
        if (CommonRegistry.isLoadComplete()) {
            throw new IllegalStateException(String.format("Tried to register synced data key %s for %s after game initialization", keyId, classKey.id()));
        }
        if (this.registeredDataKeys.contains(dataKey)) {
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is already registered", keyId, classKey.id()));
        }
        this.registerClassKey(dataKey.classKey());
        this.registeredDataKeys.add(dataKey);
        ((HashMap)this.classToKeys.computeIfAbsent(classKey, c -> new HashMap())).put(keyId, dataKey);
        int nextId = this.nextIdTracker.getAndIncrement();
        this.internalIds.put(dataKey, nextId);
        this.syncedIdToKey.put(nextId, dataKey);
        GunMod.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered synced data key {} for {}", (Object)dataKey.id(), (Object)classKey.id());
    }

    public <E extends class_1297, T> void set(E entity, SyncedDataKey<?, ?> key, T value) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            GunMod.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        if (holder != null && holder.set(entity, key, value) && !entity.method_37908().method_8608()) {
            this.dirty = true;
            this.dirtyEntities.add(entity);
        }
    }

    public <E extends class_1297, T> T get(E entity, SyncedDataKey<E, T> key) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            GunMod.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        return holder != null ? holder.get(key) : key.defaultValueSupplier().get();
    }

    public int getInternalId(SyncedDataKey<?, ?> key) {
        return this.internalIds.getInt(key);
    }

    @Nullable
    public SyncedClassKey<?> getClassKey(class_2960 id) {
        return (SyncedClassKey)this.idToClassKey.get((Object)id);
    }

    @Nullable
    public SyncedDataKey<?, ?> getKey(int id) {
        return (SyncedDataKey)this.syncedIdToKey.get(id);
    }

    @Nullable
    public SyncedDataKey<?, ?> getKey(SyncedClassKey<?> classKey, class_2960 dataKey) {
        Map keys = (Map)SyncedEntityData.instance().classToKeys.get(classKey);
        if (keys == null) {
            return null;
        }
        return (SyncedDataKey)keys.get(dataKey);
    }

    public Set<SyncedDataKey<?, ?>> getKeys() {
        return ImmutableSet.copyOf(this.registeredDataKeys);
    }

    @Nullable
    public DataHolder getDataHolder(class_1297 entity) {
        return DataHolderCapabilityProvider.CAPABILITY.maybeGet((Object)entity).map(DataHolderCapabilityProvider::getDataHolder).orElse(null);
    }

    public boolean hasSyncedDataKey(Class<? extends class_1297> entityClass) {
        Object2BooleanMap<String> cache = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? this.clientClassNameCapabilityCache : this.serverClassNameCapabilityCache;
        return cache.computeIfAbsent((Object)entityClass.getName(), c -> {
            Class targetClass = entityClass;
            while (!targetClass.isAssignableFrom(class_1297.class)) {
                if (this.classNameToClassKey.containsKey((Object)targetClass.getName())) {
                    return true;
                }
                targetClass = targetClass.getSuperclass();
            }
            return false;
        });
    }

    public boolean updateMappings(Map<class_2960, List<Pair<class_2960, Integer>>> keyMap) {
        this.syncedIdToKey.clear();
        ArrayList missingKeys = new ArrayList();
        keyMap.forEach((classId, list) -> {
            SyncedClassKey classKey = (SyncedClassKey)this.idToClassKey.get(classId);
            if (classKey == null || !this.classToKeys.containsKey((Object)classKey)) {
                list.forEach(pair -> missingKeys.add(Pair.of((Object)classId, (Object)((class_2960)pair.getLeft()))));
                return;
            }
            Map keys = (Map)this.classToKeys.get((Object)classKey);
            list.forEach(pair -> {
                SyncedDataKey syncedDataKey = (SyncedDataKey)keys.get(pair.getLeft());
                if (syncedDataKey == null) {
                    missingKeys.add(Pair.of((Object)classId, (Object)((class_2960)pair.getLeft())));
                    return;
                }
                this.syncedIdToKey.put(((Integer)pair.getRight()).intValue(), (Object)syncedDataKey);
            });
        });
        if (!missingKeys.isEmpty()) {
            String keys = missingKeys.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            GunMod.LOGGER.info(SYNCED_ENTITY_DATA_MARKER, "Received unknown synced keys: {}", (Object)keys);
        }
        return missingKeys.isEmpty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public List<class_1297> getDirtyEntities() {
        return this.dirtyEntities;
    }
}

