/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.event;

import com.imguns.guns.entity.sync.core.DataEntry;
import com.imguns.guns.entity.sync.core.DataHolder;
import com.imguns.guns.entity.sync.core.SyncedDataKey;
import com.imguns.guns.entity.sync.core.SyncedEntityData;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.ServerMessageUpdateEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SyncedEntityDataEvent {
    public static void onStartTracking(class_1297 entity, class_3222 player) {
        DataHolder holder;
        if (!player.method_37908().method_8608() && (holder = SyncedEntityData.instance().getDataHolder(entity)) != null) {
            List<DataEntry<?, ?>> entries = holder.gatherAll();
            entries.removeIf(entry -> !entry.getKey().syncMode().isTracking());
            if (!entries.isEmpty()) {
                NetworkHandler.sendToClientPlayer(new ServerMessageUpdateEntityData(entity.method_5628(), entries), (class_1657)player);
            }
        }
    }

    public static boolean onPlayerJoinWorld(class_1297 entity, class_1937 world, boolean ignoredLoadedFromDisk) {
        if (entity instanceof class_1657) {
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            class_1657 player = (class_1657)entity;
            if (!world.method_8608() && (holder = SyncedEntityData.instance().getDataHolder((class_1297)player)) != null && !(entries = holder.gatherAll()).isEmpty()) {
                NetworkHandler.sendToClientPlayer(new ServerMessageUpdateEntityData(player.method_5628(), entries), player);
            }
        }
        return true;
    }

    public static void copyFromPlayer(class_3222 original, class_3222 player, boolean alive) {
        DataHolder oldHolder = SyncedEntityData.instance().getDataHolder((class_1297)original);
        if (oldHolder == null) {
            return;
        }
        DataHolder newHolder = SyncedEntityData.instance().getDataHolder((class_1297)player);
        if (newHolder == null) {
            return;
        }
        HashMap dataMap = new HashMap(oldHolder.dataMap);
        if (!alive) {
            dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).persistent());
        }
        newHolder.dataMap = dataMap;
    }

    public static void onServerTick(MinecraftServer ignoredServer) {
        SyncedEntityData instance = SyncedEntityData.instance();
        if (!instance.isDirty()) {
            return;
        }
        List<class_1297> dirtyEntities = instance.getDirtyEntities();
        if (dirtyEntities.isEmpty()) {
            instance.setDirty(false);
            return;
        }
        for (class_1297 entity : dirtyEntities) {
            List<DataEntry<?, ?>> trackingEntries;
            List<DataEntry<?, ?>> entries;
            DataHolder holder = instance.getDataHolder(entity);
            if (holder == null || !holder.isDirty() || (entries = holder.gatherDirty()).isEmpty()) continue;
            List<DataEntry<?, ?>> selfEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isSelf()).collect(Collectors.toList());
            if (!selfEntries.isEmpty() && entity instanceof class_3222) {
                NetworkHandler.sendToClientPlayer(new ServerMessageUpdateEntityData(entity.method_5628(), selfEntries), (class_1657)((class_3222)entity));
            }
            if (!(trackingEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isTracking()).collect(Collectors.toList())).isEmpty()) {
                NetworkHandler.sendToTrackingEntity(new ServerMessageUpdateEntityData(entity.method_5628(), trackingEntries), entity);
            }
            holder.clean();
        }
        dirtyEntities.clear();
        instance.setDirty(false);
    }
}

