/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.mixin.client;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.client.event.InputEvent;
import com.imguns.guns.api.entity.IGunOperator;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.imguns.guns.client.resource.index.ClientAttachmentIndex;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.config.client.ZoomConfig;
import com.imguns.guns.util.math.MathUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_312.class})
public class MouseMixin {
    @Shadow
    @Final
    private class_310 field_1779;

    @WrapOperation(method={"updateMouse"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;changeLookDirection(DD)V")})
    public void reduceSensitivity(class_746 player, double yaw, double pitch, Operation<Void> original) {
        class_1799 mainHandItem = player.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            original.call(new Object[]{player, yaw, pitch});
            return;
        }
        class_2960 attachmentId = iGun.getAttachmentId(mainHandItem, AttachmentType.SCOPE);
        float zoomLevel = 1.0f;
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            class_2960 gunId = iGun.getGunId(mainHandItem);
            zoomLevel = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        } else {
            float[] zoom;
            Optional<ClientAttachmentIndex> optional = TimelessAPI.getClientAttachmentIndex(attachmentId);
            if (optional.isPresent() && (zoom = optional.get().getZoom()) != null && zoom.length > 0) {
                class_2487 attachmentTag = iGun.getAttachmentTag(mainHandItem, AttachmentType.SCOPE);
                zoomLevel = zoom[AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag) % zoom.length];
            }
        }
        class_310 minecraft = class_310.method_1551();
        float progress = IGunOperator.fromLivingEntity((class_1309)player).getSynAimingProgress();
        double sensitivityMultiplier = (Double)ZoomConfig.ZOOM_SENSITIVITY_BASE_MULTIPLIER.get();
        sensitivityMultiplier = 1.0 + (sensitivityMultiplier - 1.0) * (double)progress;
        double originalFov = ((Integer)minecraft.field_1690.method_41808().method_41753()).intValue();
        double currentFov = MathUtil.magnificationToFov(1.0f + (zoomLevel - 1.0f) * progress, originalFov);
        double coefficient = (Double)ZoomConfig.SCREEN_DISTANCE_COEFFICIENT.get();
        double denominator = MathUtil.zoomSensitivityRatio(currentFov, originalFov, coefficient) * sensitivityMultiplier;
        original.call(new Object[]{player, yaw * denominator, pitch * denominator});
    }

    @Inject(method={"onMouseButton"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;getOverlay()Lnet/minecraft/client/gui/screen/Overlay;", ordinal=0, shift=At.Shift.BEFORE)}, cancellable=true)
    private void onMouseButtonPre(long window, int button, int action, int mods, CallbackInfo ci) {
        if (new InputEvent.MouseButton.Pre(button, action, mods).post()) {
            ci.cancel();
        }
    }

    @Inject(method={"onMouseButton"}, at={@At(value="TAIL")})
    private void onMouseButton(long window, int button, int action, int mods, CallbackInfo ci) {
        if (window == this.field_1779.method_22683().method_4490()) {
            new InputEvent.MouseButton.Post(button, action, mods).post();
        }
    }
}

