/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.network;

import com.imguns.guns.network.NetworkClientInitializer;
import com.imguns.guns.network.message.ClientMessageCraft;
import com.imguns.guns.network.message.ClientMessagePlayerAim;
import com.imguns.guns.network.message.ClientMessagePlayerBoltGun;
import com.imguns.guns.network.message.ClientMessagePlayerDrawGun;
import com.imguns.guns.network.message.ClientMessagePlayerFireSelect;
import com.imguns.guns.network.message.ClientMessagePlayerMelee;
import com.imguns.guns.network.message.ClientMessagePlayerReloadGun;
import com.imguns.guns.network.message.ClientMessagePlayerShoot;
import com.imguns.guns.network.message.ClientMessagePlayerZoom;
import com.imguns.guns.network.message.ClientMessageRefitGun;
import com.imguns.guns.network.message.ClientMessageUnloadAttachment;
import com.imguns.guns.util.EnvironmentUtil;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class NetworkHandler {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerShoot.TYPE, ClientMessagePlayerShoot::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerReloadGun.TYPE, ClientMessagePlayerReloadGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerFireSelect.TYPE, ClientMessagePlayerFireSelect::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerAim.TYPE, ClientMessagePlayerAim::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerDrawGun.TYPE, ClientMessagePlayerDrawGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageCraft.TYPE, ClientMessageCraft::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerZoom.TYPE, ClientMessagePlayerZoom::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageRefitGun.TYPE, ClientMessageRefitGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerBoltGun.TYPE, ClientMessagePlayerBoltGun::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessageUnloadAttachment.TYPE, ClientMessageUnloadAttachment::handle);
        ServerPlayNetworking.registerGlobalReceiver(ClientMessagePlayerMelee.TYPE, ClientMessagePlayerMelee::handle);
        if (EnvironmentUtil.isClient()) {
            NetworkClientInitializer.init();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends FabricPacket> void sendToServer(T message) {
        ClientPlayNetworking.send(message);
    }

    public static <T extends FabricPacket> void sendToClientPlayer(T message, class_1657 player) {
        ServerPlayNetworking.send((class_3222)((class_3222)player), message);
    }

    public static <T extends FabricPacket> void sendToTrackingEntityAndSelf(class_1297 centerEntity, T message) {
        ((class_3215)centerEntity.method_5770().method_8398()).method_18751(centerEntity, NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToAllPlayers(MinecraftServer server, T message) {
        server.method_3760().method_14581(NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToTrackingEntity(T message, class_1297 centerEntity) {
        ((class_3215)centerEntity.method_5770().method_8398()).method_18754(centerEntity, NetworkHandler.toVanillaPacket(message));
    }

    public static <T extends FabricPacket> void sendToDimension(T message, class_1297 centerEntity) {
        class_5321 dimension = centerEntity.method_37908().method_27983();
        MinecraftServer server = centerEntity.method_5682();
        if (server != null) {
            server.method_3760().method_14589(NetworkHandler.toVanillaPacket(message), dimension);
        }
    }

    public static <T extends FabricPacket> class_2596<class_2602> toVanillaPacket(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)packet.getType().getId(), (class_2540)buf);
    }
}

