/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.network.message;

import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.builder.AmmoItemBuilder;
import com.imguns.guns.network.message.ServerMessageRefreshRefitScreen;
import com.imguns.guns.util.AttachmentDataUtils;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessageRefitGun
implements FabricPacket {
    public static final PacketType<ClientMessageRefitGun> TYPE = PacketType.create((class_2960)new class_2960("immersive_guns", "client_message_refit_gun"), ClientMessageRefitGun::new);
    private final int attachmentSlotIndex;
    private final int gunSlotIndex;
    private final AttachmentType attachmentType;

    public ClientMessageRefitGun(class_2540 buf) {
        this(buf.readInt(), buf.readInt(), (AttachmentType)buf.method_10818(AttachmentType.class));
    }

    public ClientMessageRefitGun(int attachmentSlotIndex, int gunSlotIndex, AttachmentType attachmentType) {
        this.attachmentSlotIndex = attachmentSlotIndex;
        this.gunSlotIndex = gunSlotIndex;
        this.attachmentType = attachmentType;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.attachmentSlotIndex);
        buf.writeInt(this.gunSlotIndex);
        buf.method_10817((Enum)this.attachmentType);
    }

    public void handle(class_3222 player, PacketSender sender) {
        if (player == null) {
            return;
        }
        class_1661 inventory = player.method_31548();
        class_1799 attachmentItem = inventory.method_5438(this.attachmentSlotIndex);
        class_1799 gunItem = inventory.method_5438(this.gunSlotIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null && iGun.allowAttachment(gunItem, attachmentItem)) {
            class_1799 oldAttachmentItem = iGun.getAttachment(gunItem, this.attachmentType);
            iGun.installAttachment(gunItem, attachmentItem);
            inventory.method_5447(this.attachmentSlotIndex, oldAttachmentItem);
            if (this.attachmentType == AttachmentType.EXTENDED_MAG) {
                ClientMessageRefitGun.dropAllAmmo((class_1657)player, iGun, gunItem);
            }
            player.field_7498.method_7623();
            sender.sendPacket((FabricPacket)new ServerMessageRefreshRefitScreen());
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    private static void dropAllAmmo(class_1657 player, IGun iGun, class_1799 gunItem) {
        int ammoCount = iGun.getCurrentAmmoCount(gunItem);
        if (ammoCount <= 0) {
            return;
        }
        class_2960 gunId = iGun.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            class_2960 ammoId = index.getGunData().getAmmoId();
            if (player.method_7337()) {
                int maxAmmCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData());
                iGun.setCurrentAmmoCount(gunItem, maxAmmCount);
                return;
            }
            TimelessAPI.getCommonAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                int stackSize = ammoIndex.getStackSize();
                int tmpAmmoCount = ammoCount;
                int roundCount = tmpAmmoCount / (stackSize + 1);
                for (int i = 0; i <= roundCount; ++i) {
                    int count = Math.min(tmpAmmoCount, stackSize);
                    class_1799 ammoItem = AmmoItemBuilder.create().setId(ammoId).setCount(count).build();
                    if (!ammoItem.method_7960() && !player.method_37908().field_9236) {
                        class_1542 entityitem = new class_1542(player.method_37908(), player.method_23317(), player.method_23318() + 0.5, player.method_23321(), ammoItem);
                        entityitem.method_6982(40);
                        entityitem.method_18799(entityitem.method_18798().method_18805(0.0, 1.0, 0.0));
                        player.method_37908().method_8649((class_1297)entityitem);
                    }
                    tmpAmmoCount -= stackSize;
                }
                iGun.setCurrentAmmoCount(gunItem, 0);
            });
        });
    }
}

