/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.network.message;

import com.imguns.guns.entity.sync.core.DataEntry;
import com.imguns.guns.entity.sync.core.SyncedEntityData;
import com.imguns.guns.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ServerMessageUpdateEntityData
implements FabricPacket {
    public static final PacketType<ServerMessageUpdateEntityData> TYPE = PacketType.create((class_2960)new class_2960("immersive_guns", "server_message_update_entity_data"), ServerMessageUpdateEntityData::new);
    private final int entityId;
    private final List<DataEntry<?, ?>> entries;

    public ServerMessageUpdateEntityData(class_2540 buf) {
        this(buf.method_10816(), ServerMessageUpdateEntityData.readEntries(buf));
    }

    public ServerMessageUpdateEntityData(int entityId, List<DataEntry<?, ?>> entries) {
        this.entityId = entityId;
        this.entries = entries;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.entityId);
        buf.method_10804(this.entries.size());
        this.entries.forEach(entry -> entry.write(buf));
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_1657 ignoredPlayer, PacketSender ignoredSender) {
        if (EnvironmentUtil.isClient()) {
            ServerMessageUpdateEntityData.onHandle(this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void onHandle(ServerMessageUpdateEntityData message) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_1297 entity = world.method_8469(message.entityId);
        if (entity == null) {
            return;
        }
        SyncedEntityData instance = SyncedEntityData.instance();
        message.entries.forEach(entry -> instance.set(entity, entry.getKey(), entry.getValue()));
    }

    private static List<DataEntry<?, ?>> readEntries(class_2540 buf) {
        int size = buf.method_10816();
        ArrayList entries = new ArrayList();
        for (int i = 0; i < size; ++i) {
            entries.add(DataEntry.read(buf));
        }
        return entries;
    }
}

