/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.resource.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.imguns.guns.GunMod;
import com.imguns.guns.resource.CommonAssetManager;
import com.imguns.guns.resource.CommonGunPackLoader;
import com.imguns.guns.resource.network.CommonGunPackNetwork;
import com.imguns.guns.resource.network.DataType;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.util.IOReader;
import com.imguns.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class GunDataLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"GunDataLoader");
    private static final Pattern DATA_PATTERN = Pattern.compile("^(\\w+)/guns/data/([\\w/]+)\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = DATA_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = TacPathVisitor.checkNamespace(matcher.group(1));
                String path = matcher.group(2);
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    class_2960 registryName = new class_2960(namespace, path);
                    String json = IOReader.toString(stream, StandardCharsets.UTF_8);
                    GunDataLoader.loadFromJsonString(registryName, json);
                    CommonGunPackNetwork.addData(DataType.GUN_DATA, registryName, json);
                    bl = true;
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read data file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("guns/data");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    String json = IOReader.toString(stream, StandardCharsets.UTF_8);
                    GunDataLoader.loadFromJsonString(id, json);
                    CommonGunPackNetwork.addData(DataType.GUN_DATA, id, json);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read data file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }

    public static void loadFromJsonString(class_2960 id, String json) {
        GunData data = (GunData)CommonGunPackLoader.GSON.fromJson(json, GunData.class);
        CommonAssetManager.INSTANCE.putGunData(id, data);
    }
}

