/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.resource.network;

import com.google.common.collect.Maps;
import com.imguns.guns.client.resource.ClientGunPackLoader;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.ServerMessageSyncGunPack;
import com.imguns.guns.resource.loader.asset.AllowAttachmentTagsLoader;
import com.imguns.guns.resource.loader.asset.AttachmentDataLoader;
import com.imguns.guns.resource.loader.asset.AttachmentTagsLoader;
import com.imguns.guns.resource.loader.asset.GunDataLoader;
import com.imguns.guns.resource.loader.asset.RecipeLoader;
import com.imguns.guns.resource.loader.index.CommonAmmoIndexLoader;
import com.imguns.guns.resource.loader.index.CommonAttachmentIndexLoader;
import com.imguns.guns.resource.loader.index.CommonGunIndexLoader;
import com.imguns.guns.resource.network.DataType;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class CommonGunPackNetwork {
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final EnumMap<DataType, Map<class_2960, String>> NETWORK_CACHE = new EnumMap(DataType.class);

    public static void clear() {
        NETWORK_CACHE.clear();
    }

    public static void addData(DataType type, class_2960 id, String json) {
        NETWORK_CACHE.computeIfAbsent(type, k -> Maps.newHashMap()).put(id, json);
    }

    public static void syncClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> NetworkHandler.sendToClientPlayer(new ServerMessageSyncGunPack(NETWORK_CACHE), (class_1657)player));
    }

    public static void syncClientExceptSelf(MinecraftServer server, @Nullable class_1657 self) {
        server.method_3760().method_14571().forEach(player -> {
            if (!player.equals((Object)self)) {
                ServerMessageSyncGunPack message = new ServerMessageSyncGunPack(NETWORK_CACHE);
                NetworkHandler.sendToClientPlayer(message, (class_1657)player);
            }
        });
    }

    public static void syncClient(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)new ServerMessageSyncGunPack(NETWORK_CACHE));
    }

    public static void toNetwork(EnumMap<DataType, Map<class_2960, String>> cache, class_2540 buf) {
        buf.method_10804(cache.size());
        cache.forEach((type, caches) -> {
            buf.method_10817((Enum)type);
            buf.method_10804(caches.size());
            caches.forEach((id, data) -> {
                buf.method_10812(id);
                buf.method_10814(data);
            });
        });
    }

    public static EnumMap<DataType, Map<class_2960, String>> fromNetworkCache(class_2540 buf) {
        EnumMap cache = Maps.newEnumMap(DataType.class);
        int typeSize = buf.method_10816();
        for (int i = 0; i < typeSize; ++i) {
            DataType type = (DataType)buf.method_10818(DataType.class);
            int size = buf.method_10816();
            for (int j = 0; j < size; ++j) {
                class_2960 id = buf.method_10810();
                String json = buf.method_19772();
                cache.computeIfAbsent(type, k -> Maps.newHashMap()).put(id, json);
            }
        }
        return cache;
    }

    @Environment(value=EnvType.CLIENT)
    public static void loadFromCache(EnumMap<DataType, Map<class_2960, String>> allCache) {
        allCache.forEach((type, cache) -> cache.forEach((id, json) -> {
            switch (type) {
                case GUN_DATA: {
                    GunDataLoader.loadFromJsonString(id, json);
                    break;
                }
                case ATTACHMENT_DATA: {
                    AttachmentDataLoader.loadFromJsonString(id, json);
                    break;
                }
                case AMMO_INDEX: {
                    CommonAmmoIndexLoader.loadAmmoFromJsonString(id, json);
                    break;
                }
                case GUN_INDEX: {
                    CommonGunIndexLoader.loadGunFromJsonString(id, json);
                    break;
                }
                case ATTACHMENT_INDEX: {
                    CommonAttachmentIndexLoader.loadAttachmentFromJsonString(id, json);
                    break;
                }
                case RECIPES: {
                    RecipeLoader.loadFromJsonString(id, json);
                    break;
                }
                case ATTACHMENT_TAGS: {
                    AttachmentTagsLoader.loadFromJsonString(id, json);
                    break;
                }
                case ALLOW_ATTACHMENT_TAGS: {
                    AllowAttachmentTagsLoader.loadFromJsonString(id, json);
                }
            }
        }));
        ClientGunPackLoader.reloadIndex();
    }
}

