/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.resource.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.builder.AmmoItemBuilder;
import com.imguns.guns.api.item.builder.AttachmentItemBuilder;
import com.imguns.guns.api.item.builder.GunItemBuilder;
import com.imguns.guns.crafting.GunSmithTableResult;
import com.imguns.guns.resource.CommonGunPackLoader;
import com.imguns.guns.resource.pojo.data.recipe.GunResult;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class GunSmithTableResultSerializer
implements JsonDeserializer<GunSmithTableResult> {
    public GunSmithTableResult deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"id"));
            String typeName = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
            int count = 1;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260((JsonObject)jsonObject, (String)"count"), 1);
            }
            switch (typeName) {
                case "gun": {
                    return this.getGunStack(id, count, jsonObject);
                }
                case "ammo": {
                    return this.getAmmoStack(id, count);
                }
                case "attachment": {
                    return this.getAttachmentStack(id, count);
                }
            }
        }
        return new GunSmithTableResult(class_1799.field_8037, "");
    }

    private GunSmithTableResult getGunStack(class_2960 id, int count, JsonObject extraData) {
        GunResult gunResult = (GunResult)CommonGunPackLoader.GSON.fromJson((JsonElement)extraData, GunResult.class);
        int ammoCount = Math.max(0, gunResult.getAmmoCount());
        EnumMap<AttachmentType, class_2960> attachments = gunResult.getAttachments();
        return TimelessAPI.getCommonGunIndex(id).map(gunIndex -> {
            class_1799 itemStack = GunItemBuilder.create().setCount(count).setId(id).setAmmoCount(ammoCount).setAmmoInBarrel(false).putAllAttachment(attachments).setFireMode(gunIndex.getGunData().getFireModeSet().get(0)).build();
            String group = gunIndex.getType();
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, ""));
    }

    private GunSmithTableResult getAmmoStack(class_2960 id, int count) {
        return new GunSmithTableResult(AmmoItemBuilder.create().setCount(count).setId(id).build(), "ammo");
    }

    private GunSmithTableResult getAttachmentStack(class_2960 id, int count) {
        return TimelessAPI.getCommonAttachmentIndex(id).map(attachmentIndex -> {
            class_1799 itemStack = AttachmentItemBuilder.create().setCount(count).setId(id).build();
            String group = attachmentIndex.getType().name().toLowerCase(Locale.US);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, ""));
    }
}

