/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.util;

import com.imguns.guns.resource.CommonAssetManager;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2960;

public final class AllowAttachmentTagMatcher {
    private static final String TAG_PREFIX = "#";

    public static boolean match(class_2960 gunId, class_2960 attachmentId) {
        Set<String> allowAttachmentTags = CommonAssetManager.INSTANCE.getAllowAttachmentTags(gunId);
        if (allowAttachmentTags == null || allowAttachmentTags.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(allowAttachmentTags, attachmentId, searchSignal);
        return searchSignal.get();
    }

    private static void treeSearch(Set<String> tags, class_2960 attachmentId, AtomicBoolean searchSignal) {
        for (String tag : tags) {
            if (tag.startsWith(TAG_PREFIX)) {
                class_2960 tagId = new class_2960(tag.substring(TAG_PREFIX.length()));
                Set<String> attachmentTags = CommonAssetManager.INSTANCE.getAttachmentTags(tagId);
                if (attachmentTags == null || attachmentTags.isEmpty()) continue;
                AllowAttachmentTagMatcher.treeSearch(attachmentTags, attachmentId, searchSignal);
                continue;
            }
            class_2960 matchAttachmentId = new class_2960(tag);
            if (!attachmentId.equals((Object)matchAttachmentId)) continue;
            searchSignal.set(true);
            return;
        }
    }
}

