/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.util.item.wrapper;

import com.google.common.collect.ImmutableList;
import com.imguns.guns.util.LazyOptional;
import com.imguns.guns.util.item.IItemHandlerModifiable;
import com.imguns.guns.util.item.ItemHandlerHelper;
import com.imguns.guns.util.item.wrapper.CombinedInvWrapper;
import com.imguns.guns.util.item.wrapper.EntityArmorInvWrapper;
import com.imguns.guns.util.item.wrapper.EntityHandsInvWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final class_1309 entity;
    protected final List<class_1304> slots;

    public EntityEquipmentInvWrapper(class_1309 entity, class_1304.class_1305 slotType) {
        class_1304[] var4;
        this.entity = entity;
        ArrayList<class_1304> slots = new ArrayList<class_1304>();
        for (class_1304 slot : var4 = class_1304.values()) {
            if (slot.method_5925() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.entity.method_6118(this.validateSlotIndex(slot));
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        class_1799 existing = this.entity.method_6118(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.entity.method_5673(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        class_1799 existing = this.entity.method_6118(equipmentSlot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.entity.method_5673(equipmentSlot, class_1799.field_8037);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.method_5673(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.method_7947() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.method_5925() == class_1304.class_1305.field_6178 ? 1 : 64;
    }

    protected int getStackLimit(int slot, @NotNull class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        class_1304 equipmentSlot = this.validateSlotIndex(slot);
        if (!class_1799.method_7973((class_1799)this.entity.method_6118(equipmentSlot), (class_1799)stack)) {
            this.entity.method_5673(equipmentSlot, stack);
        }
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    protected class_1304 validateSlotIndex(int slot) {
        if (slot >= 0 && slot < this.slots.size()) {
            return this.slots.get(slot);
        }
        throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
    }

    public static LazyOptional<IItemHandlerModifiable>[] create(class_1309 entity) {
        LazyOptional[] ret = new LazyOptional[]{LazyOptional.of(() -> new EntityHandsInvWrapper(entity)), LazyOptional.of(() -> new EntityArmorInvWrapper(entity)), null};
        ret[2] = LazyOptional.of(() -> new CombinedInvWrapper(ret[0].orElse(null), ret[1].orElse(null)));
        return ret;
    }
}

