/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.util.math;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SecondOrderDynamics {
    public static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(15, Thread::new);
    private final float k1;
    private final float k2;
    private final float k3;
    private float py;
    private float pyd;
    private float px;
    private float target;

    public SecondOrderDynamics(float f, float z, float r, float x0) {
        this.k1 = (float)((double)z / (Math.PI * (double)f));
        this.k2 = (float)(1.0 / (Math.PI * 2 * (double)f * (Math.PI * 2 * (double)f)));
        this.k3 = (float)((double)(r * z) / (Math.PI * 2 * (double)f));
        this.py = this.px = x0;
        this.pyd = 0.0f;
        this.target = x0;
        executorService.execute(this::update);
    }

    public float update(float x) {
        this.target = x;
        return this.get();
    }

    public float get() {
        if (Float.isNaN(this.py)) {
            this.py = 0.0f;
        }
        if (Float.isNaN(this.pyd)) {
            this.pyd = 0.0f;
        }
        return this.py + 0.05f * this.pyd;
    }

    private void update() {
        while (true) {
            if (Float.isNaN(this.py)) {
                this.py = 0.0f;
            }
            if (Float.isNaN(this.pyd)) {
                this.pyd = 0.0f;
            }
            float t = 0.05f;
            float xd = (this.target - this.px) / t;
            float y = this.py + t * this.pyd;
            this.pyd += t * (this.px + this.k3 * xd - this.py - this.k1 * this.pyd) / this.k2;
            this.px = this.target;
            this.py = y;
            try {
                Thread.sleep(6L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    static {
        for (int i = 0; i < 15; ++i) {
            executorService.execute(() -> {});
        }
    }
}

