/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.api;

import com.basicallymods.signs.common.block.StandingSignBlock;
import com.basicallymods.signs.common.block.WallSignBlock;
import com.basicallymods.signs.common.data.ISignColor;
import com.basicallymods.signs.common.registry.ModBlocks;
import com.basicallymods.signs.common.registry.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SignsRegisterer {
    public final DeferredRegister<Block> blocksRegistry;
    public final DeferredRegister<Item> itemsRegistry;
    public final Map<ISignColor, ModBlocks.SignBlock> SIGN_BLOCKS_BY_COLOR = new HashMap<ISignColor, ModBlocks.SignBlock>();
    public final Map<ISignColor, RegistryObject<? extends Item>> SIGN_ITEMS_BY_SIGN_COLOR = new HashMap<ISignColor, RegistryObject<? extends Item>>();
    public final String MOD_ID;

    public SignsRegisterer(String MOD_ID) {
        this(MOD_ID, (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID), (DeferredRegister<Item>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID));
    }

    public SignsRegisterer(String MOD_ID, DeferredRegister<Block> blocksRegistry, DeferredRegister<Item> itemsRegistry) {
        this.blocksRegistry = blocksRegistry;
        this.itemsRegistry = itemsRegistry;
        this.MOD_ID = MOD_ID;
    }

    public void registerBasic(ISignColor sign) {
        RegistryObject standingBlock = this.blocksRegistry.register(sign.standingSignName(), () -> new StandingSignBlock(sign));
        RegistryObject wallSignBlock = this.blocksRegistry.register(sign.wallSignName(), () -> new WallSignBlock(sign));
        ModBlocks.SignBlock block = new ModBlocks.SignBlock((RegistryObject<? extends net.minecraft.world.level.block.StandingSignBlock>)standingBlock, (RegistryObject<? extends net.minecraft.world.level.block.WallSignBlock>)wallSignBlock);
        this.SIGN_BLOCKS_BY_COLOR.put(sign, block);
        ModBlocks.SIGN_BLOCKS_BY_COLOR.put(sign, block);
        RegistryObject item = this.itemsRegistry.register(sign.itemName(), () -> new SignItem(new Item.Properties().m_41487_(64), (Block)standingBlock.get(), (Block)wallSignBlock.get()));
        this.SIGN_ITEMS_BY_SIGN_COLOR.put(sign, (RegistryObject<? extends Item>)item);
        ModItems.SIGN_ITEMS_BY_SIGN_COLOR.put(sign, (RegistryObject<? extends Item>)item);
    }
}

