/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.common.data;

import com.basicallymods.signs.common.data.SignColor;
import com.basicallymods.signs.common.registry.ModItems;
import com.basicallymods.signs.common.registry.ModRecipeSerializers;
import com.basicallymods.signs.common.registry.ModRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SignRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final Ingredient dye;
    protected final ItemStack result;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;
    public static final Serializer<SignRecipe> SIGN_RECIPE_SERIALIZER = new Serializer<SignRecipe>(SignRecipe::new);

    public SignRecipe(RecipeType<?> pType, RecipeSerializer<?> pSerializer, ResourceLocation pId, String pGroup, Ingredient pIngredient, Ingredient dye, ItemStack pResult) {
        this.type = pType;
        this.serializer = pSerializer;
        this.id = pId;
        this.group = pGroup;
        this.ingredient = pIngredient;
        this.result = pResult;
        this.dye = dye;
    }

    public SignRecipe(ResourceLocation pId, String pGroup, Ingredient pIngredient, Ingredient pDye, ItemStack pResult) {
        this((RecipeType)ModRecipeTypes.SIGN_WORKBENCH_RECIPE.get(), (RecipeSerializer)ModRecipeSerializers.SIGN_WORKBENCH_RECIPE.get(), pId, pGroup, pIngredient, pDye, pResult);
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return this.type;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean m_5818_(Container pContainer, @NotNull Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0)) && this.dye.test(pContainer.m_8020_(1));
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.SIGN_ITEMS_BY_SIGN_COLOR.get(SignColor.AMBER).get());
    }

    public static class Serializer<T extends SignRecipe>
    implements RecipeSerializer<T> {
        final SingleItemMaker<T> factory;

        public Serializer(SingleItemMaker<T> pFactory) {
            this.factory = pFactory;
        }

        public T fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"), (boolean)false);
            Ingredient dye = GsonHelper.m_13885_((JsonObject)pJson, (String)"dye") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)pJson, (String)"dye"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"dye"), (boolean)false);
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), 1);
            return this.factory.create(pRecipeId, s, ingredient, dye, itemstack);
        }

        public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient dye = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            return this.factory.create(pRecipeId, s, ingredient, dye, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
            pBuffer.m_130070_(((SignRecipe)pRecipe).m_6076_());
            ((SignRecipe)pRecipe).ingredient.m_43923_(pBuffer);
            ((SignRecipe)pRecipe).dye.m_43923_(pBuffer);
            pBuffer.m_130055_(((SignRecipe)pRecipe).result);
        }

        public static interface SingleItemMaker<T extends SignRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, Ingredient var4, ItemStack var5);
        }
    }
}

