/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar;

import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class SearchHandler {
    public static String search = "";
    private final AbstractContainerScreen<?> screen;
    private final EditBox searchBar;
    private final Mode mode;
    private List<Slot> slots = new ArrayList<Slot>();

    public SearchHandler(AbstractContainerScreen<?> screen, EditBox searchBax, Mode mode) {
        this.screen = screen;
        this.searchBar = searchBax;
        this.mode = mode;
        if (Config.keepSearch) {
            this.searchBar.m_94144_(search);
        }
        if (Config.autoFocus) {
            this.searchBar.m_94178_(true);
            screen.m_7522_((GuiEventListener)this.searchBar);
        }
        this.searchBar.m_94151_(this::refreshAndUpdate);
    }

    public List<Slot> getSearchResult() {
        return this.slots;
    }

    public EditBox getSearchBar() {
        return this.searchBar;
    }

    public boolean isBarEmpty() {
        return this.searchBar.m_94155_().isEmpty();
    }

    public int getMenuSize() {
        return SearchHandler.getMenuSize(this.screen.m_6262_().f_38839_.size());
    }

    public void tick() {
        this.searchBar.m_94120_();
        if (!this.isBarEmpty()) {
            this.refreshResults(this.searchBar.m_94155_());
        }
    }

    public void refreshAndUpdate(String search) {
        SearchHandler.search = search;
        this.refreshResults(search);
    }

    public void refreshResults(String search) {
        this.slots.clear();
        for (int i = 0; i < this.getMenuSize(); ++i) {
            Slot slot = this.screen.m_6262_().m_38853_(i);
            ItemStack item = slot.m_7993_();
            if (!SearchHandler.checkItem(item, search)) continue;
            this.slots.add(slot);
        }
        if (this.slots.isEmpty() && !this.isBarEmpty()) {
            this.searchBar.m_94202_(-39836);
        } else {
            this.searchBar.m_94202_(0xFFFFFF);
        }
    }

    public boolean isSortMode() {
        return this.mode == Mode.SORT;
    }

    public static boolean checkItem(ItemStack item, String search) {
        if (item.m_41619_() || search.isEmpty()) {
            return false;
        }
        if (SearchHandler.checkName(item.m_41786_().getString(), search)) {
            return true;
        }
        if (item.m_41793_() || item.m_41720_().equals(Items.f_42690_)) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)item).entrySet()) {
                String name = Component.m_237115_((String)((Enchantment)entry.getKey()).m_44704_()).getString() + " " + entry.getValue();
                if (!SearchHandler.checkName(name, search)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkName(String item, String search) {
        return item.toLowerCase().contains(search.toLowerCase());
    }

    public static int getMenuSize(int totalSlotsSize) {
        return totalSlotsSize - Minecraft.m_91087_().f_91074_.m_150109_().f_35974_.size();
    }
}

