/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.mixin.client;

import cgcm.chestsearchbar.ChestSearchBar;
import cgcm.chestsearchbar.SearchHandler;
import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.util.Helpers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected final T f_97732_;
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97728_;
    @Shadow
    protected int f_97729_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    protected Slot f_97734_;
    @Unique
    private SearchHandler searchHandler;
    @Unique
    private static long lastClick;

    @Shadow
    protected abstract boolean m_6774_(int var1, int var2, int var3, int var4, double var5, double var7);

    @Shadow
    protected abstract boolean m_97774_(Slot var1, double var2, double var4);

    protected AbstractContainerScreenMixin(T menu, Component pTitle) {
        super(pTitle);
        this.f_97732_ = menu;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo callbackinfo) {
        AbstractContainerScreen instance = (AbstractContainerScreen)this;
        Mode mode = Config.getMode(instance, SearchHandler.getMenuSize(((AbstractContainerMenu)this.f_97732_).f_38839_.size()));
        if (instance instanceof CreativeModeInventoryScreen || instance instanceof InventoryScreen || instance instanceof CraftingScreen || mode == Mode.DISABLED) {
            return;
        }
        EditBox searchBar = new EditBox(this.f_96547_, 0, this.f_97736_ + this.f_97729_, 80, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        searchBar.m_94199_(25);
        searchBar.m_94182_(false);
        searchBar.m_94202_(0xFFFFFF);
        this.searchHandler = new SearchHandler(instance, searchBar, mode);
        this.m_7787_((GuiEventListener)searchBar);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(PoseStack pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler == null) {
            return;
        }
        int pX = this.f_97735_ + this.f_97728_ + (this.f_96539_.getString().isBlank() ? 0 : this.f_96547_.m_92895_(this.f_96539_.getString().replaceAll("\\p{C}", "")) + 3);
        int pY = this.f_97736_ + this.f_97729_;
        int xSize = this.f_97735_ + this.f_97726_ - this.f_97728_ + 2 - pX;
        if (xSize < 32) {
            int f = 32 - xSize;
            pX -= f;
            xSize += f;
        }
        Helpers.draw3SliceTexture(pGuiGraphics, ChestSearchBar.BAR_LOCATION, pX - 1, pY - 2, xSize, 0, 0, 90, 12);
        this.searchHandler.getSearchBar().m_94214_(pX + 1);
        this.searchHandler.getSearchBar().m_93674_(xSize - 2);
        this.searchHandler.getSearchBar().m_6305_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.searchHandler.isBarEmpty() || !this.searchHandler.isSortMode()) {
            return;
        }
        for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
            Slot posSlot = this.f_97732_.m_38853_(i);
            if (i < this.searchHandler.getSearchResult().size()) {
                Slot slot = this.searchHandler.getSearchResult().get(i);
                if (!this.m_6774_(posSlot.f_40220_, posSlot.f_40221_, 16, 16, pMouseX, pMouseY) || !posSlot.m_6659_()) continue;
                this.f_97734_ = slot;
                continue;
            }
            if (!this.m_6774_(posSlot.f_40220_, posSlot.f_40221_, 16, 16, pMouseX, pMouseY) || !posSlot.m_6659_()) continue;
            this.f_97734_ = null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lcom/mojang/blaze3d/vertex/PoseStack;II)V", shift=At.Shift.AFTER)})
    private void onRenderLabels(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler != null && !this.searchHandler.isBarEmpty() && !this.searchHandler.isSortMode()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot posSlot = this.f_97732_.m_38853_(i);
                if (this.searchHandler.getSearchResult().contains(posSlot)) continue;
                AbstractContainerScreenMixin.m_168740_((PoseStack)pPoseStack, (int)posSlot.f_40220_, (int)posSlot.f_40221_, (int)(posSlot.f_40220_ + 16), (int)(posSlot.f_40221_ + 16), (int)-1275068416, (int)-1275068416, (int)0);
            }
        }
    }

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack redirectGetItem(Slot slot) {
        int index = slot.f_40219_;
        if (this.searchHandler == null || this.searchHandler.isBarEmpty() || !this.searchHandler.isSortMode() || index >= this.searchHandler.getMenuSize()) {
            return slot.m_7993_();
        }
        if (this.searchHandler.getSearchResult().size() > index) {
            return this.searchHandler.getSearchResult().get(index).m_7993_();
        }
        return ItemStack.f_41583_;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (!this.searchHandler.getSearchBar().m_5953_(pMouseX, pMouseY)) {
                this.searchHandler.getSearchBar().m_94178_(false);
            } else {
                long time = System.currentTimeMillis();
                long d = time - lastClick;
                if (d < 200L && this.searchHandler.getSearchBar().m_93696_() && !this.searchHandler.isBarEmpty()) {
                    this.searchHandler.getSearchBar().m_94144_("");
                    SearchHandler.search = "";
                }
                lastClick = time;
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null && this.searchHandler.getSearchBar().m_93696_() && pKeyCode != 256) {
            this.searchHandler.getSearchBar().m_7933_(pKeyCode, pScanCode, pModifiers);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.searchHandler != null) {
            this.searchHandler.tick();
        }
    }

    @Inject(method={"findSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void findSlot(double pMouseX, double pMouseY, CallbackInfoReturnable<Slot> cir) {
        if (this.searchHandler != null && this.searchHandler.isSortMode() && !this.searchHandler.isBarEmpty()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                Slot slot = this.f_97732_.m_38853_(i);
                if (!this.m_97774_(slot, pMouseX, pMouseY) || !slot.m_6659_()) continue;
                if (i < this.searchHandler.getSearchResult().size()) {
                    cir.setReturnValue((Object)this.searchHandler.getSearchResult().get(i));
                    continue;
                }
                cir.setReturnValue(null);
            }
        }
    }
}

