/*
 * Decompiled with CFR 0.152.
 */
package dev.bluevista.illusions.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.bluevista.illusions.compat.Iris;
import dev.bluevista.illusions.entity.MirrorEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5365;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.ladysnake.satin.api.managed.ManagedCoreShader;
import org.ladysnake.satin.api.managed.ShaderEffectManager;
import org.ladysnake.satin.api.managed.uniform.Uniform1i;

@Environment(value=EnvType.CLIENT)
public class MirrorRenderer {
    public static final ManagedCoreShader SHADER = ShaderEffectManager.getInstance().manageCoreShader(class_2960.method_60655((String)"illusions", (String)"warp"), class_290.field_1585);
    public static final Uniform1i DISTORTION_TYPE = SHADER.findUniform1i("DistortionType");
    public static final class_2960 MIRROR_PLACEHOLDER_TEXTURE = class_2960.method_60655((String)"illusions", (String)"textures/mirror_placeholder.png");
    public static final int MAX_MIRRORS_DEEP = 3;
    private static final class_276[] framebuffers = new class_276[3];
    private static int mirrorsDeep;

    public static boolean isDrawing() {
        return mirrorsDeep > 0;
    }

    public static boolean canDraw() {
        boolean fabulous = class_310.method_1551().field_1690.method_42534().method_41753() == class_5365.field_25429;
        boolean iris = Iris.isInstalled();
        return !iris && !fabulous && mirrorsDeep < 3;
    }

    @Nullable
    public static class_276 getFramebuffer() {
        if (!MirrorRenderer.canDraw()) {
            return null;
        }
        return framebuffers[mirrorsDeep - 1];
    }

    public static void onResize(int width, int height) {
        for (int i = 0; i < framebuffers.length; ++i) {
            MirrorRenderer.framebuffers[i] = new class_6367(width, height, true, false);
        }
    }

    public static void onRenderWorld(WorldRenderContext ctx) {
        for (class_1297 entity : ctx.world().method_18112()) {
            if (!(entity instanceof MirrorEntity)) continue;
            MirrorEntity mirror = (MirrorEntity)entity;
            class_243 cameraPos = ctx.camera().method_19326();
            class_243 entityPos = entity.method_19538();
            float cameraYaw = ctx.camera().method_19330();
            float entityYaw = mirror.method_36454();
            float epsilon = 180.0f;
            if (!(entityPos.method_1022(cameraPos) < 128.0) || entity.method_37908().method_17742(new class_3959(cameraPos, entityPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() != class_239.class_240.field_1333 || !(Math.abs(entityYaw - cameraYaw) % 360.0f < 180.0f + epsilon) || !(Math.abs(entityYaw - cameraYaw) % 360.0f > 180.0f - epsilon)) continue;
            MirrorRenderer.renderMirror(mirror, ctx.matrixStack(), ctx.tickCounter().method_60637(false));
        }
    }

    private static void renderMirror(MirrorEntity entity, class_4587 matrices, float tickDelta) {
        int tex = MirrorRenderer.renderWorld(entity);
        if (tex == -1) {
            tex = class_310.method_1551().method_1531().method_4619(MIRROR_PLACEHOLDER_TEXTURE).method_4624();
        }
        RenderSystem.setShader(() -> ((ManagedCoreShader)SHADER).getProgram());
        RenderSystem.setShaderTexture((int)0, (int)tex);
        RenderSystem.enableDepthTest();
        DISTORTION_TYPE.set(entity.getDistortionType().ordinal());
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 entityPos = entity.method_30950(tickDelta);
        class_243 cameraPos = camera.method_19326();
        class_243 translation = entityPos.method_1020(cameraPos);
        matrices.method_22903();
        matrices.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);
        matrices.method_22907(entity.method_58149().method_23224());
        matrices.method_22904(0.0, 0.033, 0.0);
        class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float tWidth = 0.2f;
        float tHeight = 0.5f;
        float vWidth = 0.45f;
        float vHeight = 0.95f;
        buffer.method_22918(matrices.method_23760().method_23761(), -vWidth, 0.0f, -vHeight).method_22913(0.5f + tWidth, 0.5f + tHeight);
        buffer.method_22918(matrices.method_23760().method_23761(), -vWidth, 0.0f, vHeight).method_22913(0.5f + tWidth, 0.5f - tHeight);
        buffer.method_22918(matrices.method_23760().method_23761(), vWidth, 0.0f, vHeight).method_22913(0.5f - tWidth, 0.5f - tHeight);
        buffer.method_22918(matrices.method_23760().method_23761(), vWidth, 0.0f, -vHeight).method_22913(0.5f - tWidth, 0.5f + tHeight);
        class_286.method_43433((class_9801)buffer.method_60800());
        matrices.method_22909();
    }

    private static int renderWorld(MirrorEntity entity) {
        if (!MirrorRenderer.canDraw()) {
            return -1;
        }
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        Vector3f position = entity.getCenterPos();
        class_2350 direction = entity.method_58149();
        try {
            Matrix4fStack oldModelViewStack = RenderSystem.getModelViewStack();
            Matrix4f oldModelViewMat = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            Matrix4f prevProjMat = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            class_4604 oldFrustum = client.field_1769.field_27740;
            class_243 oldPos = camera.field_18712;
            float oldYaw = camera.method_19330();
            float oldPitch = camera.method_19329();
            int oldFboWidth = client.method_22683().method_4489();
            int oldFboHeight = client.method_22683().method_4506();
            camera.field_18712 = new class_243(position);
            camera.method_19325(direction.method_10144(), 0.0f);
            Quaternionf cameraRotation = camera.method_23767();
            Matrix4f rotMat = new Matrix4f().rotate((Quaternionfc)cameraRotation.conjugate(new Quaternionf()));
            Matrix4f projMat = client.field_1773.method_22973(70.0);
            client.field_1769.method_32133(camera.method_19326(), rotMat, projMat);
            RenderSystem.viewport((int)0, (int)0, (int)class_310.method_1551().method_1522().field_1482, (int)class_310.method_1551().method_1522().field_1481);
            ++mirrorsDeep;
            class_276 framebuffer = MirrorRenderer.getFramebuffer();
            if (framebuffer == null) {
                --mirrorsDeep;
                return -1;
            }
            framebuffer.method_1230(class_310.field_1703);
            framebuffer.method_1235(true);
            client.method_22683().method_35642(framebuffer.field_1482);
            client.method_22683().method_35643(framebuffer.field_1481);
            client.field_1773.method_22709(projMat);
            RenderSystem.modelViewStack = new Matrix4fStack(16);
            client.field_1769.method_22710(client.method_60646(), false, camera, client.field_1773, client.field_1773.method_22974(), rotMat, projMat);
            --mirrorsDeep;
            client.method_1522().method_1235(false);
            camera.field_18712 = oldPos;
            camera.method_19325(oldYaw, oldPitch);
            client.field_1769.field_27740 = oldFrustum;
            client.field_1773.method_22709(prevProjMat);
            RenderSystem.modelViewStack = oldModelViewStack;
            RenderSystem.modelViewMatrix = oldModelViewMat;
            client.method_22683().method_35642(oldFboWidth);
            client.method_22683().method_35643(oldFboHeight);
            RenderSystem.viewport((int)0, (int)0, (int)client.method_22683().method_4489(), (int)client.method_22683().method_4506());
            return framebuffer.method_30277();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }
}

