/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MultiBlock {
    public static final MultiBlock INITIALIZE = new MultiBlock();

    public boolean checkMultiBlock(Map<Integer, List<Block>> maps, Player player, Level world, BlockPos basePos, int ox, int oz, Direction face, Block target, int maxY) {
        if (maps.size() < maxY) {
            return false;
        }
        Processor processor = new Processor(maps);
        switch (face) {
            case EAST: {
                int y;
                BlockPos originPos = new BlockPos(basePos.m_123341_() + ox, basePos.m_123342_(), basePos.m_123343_() - oz);
                for (y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int x = 0; x > -5; --x) {
                        for (int z = 0; z < 5; ++z) {
                            if (!processor.checkBlockInMap(world, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), y, i)) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                for (y = 0; y < maxY; ++y) {
                    for (int x = 0; x > -5; --x) {
                        for (int z = 0; z < 5; ++z) {
                            BlockPos pos0 = new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z);
                            world.m_46961_(pos0, false);
                            world.m_46597_(basePos, Objects.requireNonNull(target.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, player.m_21205_(), BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)face, (BlockPos)basePos)))));
                        }
                    }
                }
                break;
            }
            case SOUTH: {
                int y;
                BlockPos originPos = new BlockPos(basePos.m_123341_() + oz, basePos.m_123342_(), basePos.m_123343_() + ox);
                for (y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int z = 0; z > -5; --z) {
                        for (int x = 0; x > -5; --x) {
                            if (!processor.checkBlockInMap(world, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), y, i)) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                for (y = 0; y < maxY; ++y) {
                    for (int z = 0; z > -5; --z) {
                        for (int x = 0; x > -5; --x) {
                            BlockPos pos0 = new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z);
                            world.m_46961_(pos0, false);
                            world.m_46597_(basePos, Objects.requireNonNull(target.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, player.m_21205_(), BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)face, (BlockPos)basePos)))));
                        }
                    }
                }
                break;
            }
            case WEST: {
                int y;
                BlockPos originPos = new BlockPos(basePos.m_123341_() - ox, basePos.m_123342_(), basePos.m_123343_() + oz);
                for (y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int x = 0; x < 5; ++x) {
                        for (int z = 0; z > -5; --z) {
                            if (!processor.checkBlockInMap(world, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), y, i)) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                for (y = 0; y < maxY; ++y) {
                    for (int x = 0; x < 5; ++x) {
                        for (int z = 0; z > -5; --z) {
                            BlockPos pos0 = new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z);
                            world.m_46961_(pos0, false);
                            world.m_46597_(basePos, Objects.requireNonNull(target.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, player.m_21205_(), BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)face, (BlockPos)basePos)))));
                        }
                    }
                }
                break;
            }
            case NORTH: {
                int y;
                BlockPos originPos = new BlockPos(basePos.m_123341_() - oz, basePos.m_123342_(), basePos.m_123343_() - ox);
                for (y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int z = 0; z < 5; ++z) {
                        for (int x = 0; x < 5; ++x) {
                            if (!processor.checkBlockInMap(world, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), y, i)) {
                                return false;
                            }
                            ++i;
                        }
                    }
                }
                for (y = 0; y < maxY; ++y) {
                    for (int z = 0; z < 5; ++z) {
                        for (int x = 0; x < 5; ++x) {
                            BlockPos pos0 = new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z);
                            world.m_46961_(pos0, false);
                            world.m_46597_(basePos, Objects.requireNonNull(target.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, player.m_21205_(), BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)face, (BlockPos)basePos)))));
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public void setMultiBlock(Map<Integer, List<Block>> map, Player player, Level world, BlockPos pos, int ox, int oz, Direction face, int maxY) {
        Processor processor = new Processor(map);
        switch (face) {
            case EAST: {
                BlockPos originPos = new BlockPos(pos.m_123341_() + ox, pos.m_123342_(), pos.m_123343_() - oz);
                for (int y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int x = 0; x > -5; --x) {
                        for (int z = 0; z < 5; ++z) {
                            processor.setBlockInMap(world, player, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), face, y, i);
                            ++i;
                        }
                    }
                }
                break;
            }
            case SOUTH: {
                BlockPos originPos = new BlockPos(pos.m_123341_() + oz, pos.m_123342_(), pos.m_123343_() + ox);
                for (int y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int z = 0; z > -5; --z) {
                        for (int x = 0; x > -5; --x) {
                            processor.setBlockInMap(world, player, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), face, y, i);
                            ++i;
                        }
                    }
                }
                break;
            }
            case WEST: {
                BlockPos originPos = new BlockPos(pos.m_123341_() - ox, pos.m_123342_(), pos.m_123343_() + oz);
                for (int y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int x = 0; x < 5; ++x) {
                        for (int z = 0; z > -5; --z) {
                            processor.setBlockInMap(world, player, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), face, y, i);
                            ++i;
                        }
                    }
                }
                break;
            }
            case NORTH: {
                BlockPos originPos = new BlockPos(pos.m_123341_() - oz, pos.m_123342_(), pos.m_123343_() - ox);
                for (int y = 0; y < maxY; ++y) {
                    int i = 0;
                    for (int z = 0; z < 5; ++z) {
                        for (int x = 0; x < 5; ++x) {
                            processor.setBlockInMap(world, player, new BlockPos(originPos.m_123341_() + x, originPos.m_123342_() + y, originPos.m_123343_() + z), face, y, i);
                            ++i;
                        }
                    }
                }
                break;
            }
        }
    }

    public class Processor {
        Map<Integer, List<Block>> maps;

        public Processor(Map<Integer, List<Block>> maps) {
            this.maps = maps;
        }

        public boolean checkBlockInMap(Level world, BlockPos pos, int y, int size) {
            Block block = this.maps.get(y).get(size);
            if (block == null || block == Blocks.f_50016_) {
                return true;
            }
            return world.m_8055_(pos).m_60713_(block);
        }

        public void setBlockInMap(Level world, Player player, BlockPos pos, Direction face, int y, int size) {
            Block block = this.maps.get(y).get(size);
            if (block == null || block == Blocks.f_50016_) {
                return;
            }
            world.m_46597_(pos, Objects.requireNonNull(block.m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, player.m_21205_(), BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)face, (BlockPos)pos)))));
        }
    }
}

