/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.pasterdream.init.PasterdreamModItems;
import net.pasterdream.jei.claypot.Claypot;
import net.pasterdream.jei.claypot.ClaypotDataRecipe;
import net.pasterdream.jei.dreamcauldron.DreamCauldron;
import net.pasterdream.jei.dreamcauldron.DreamCauldronRecipe;
import net.pasterdream.jei.shadowblastfurnace.BlastCategory;
import net.pasterdream.jei.shadowblastfurnace.BlastDataRecipe;
import net.pasterdream.jei.weaponworkshop.WeaponworkshopCategory;
import net.pasterdream.jei.weaponworkshop.WeaponworkshopDataRecipe;

@JeiPlugin
public class Plugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("pasterdream", "pasterdream.jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BlastCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WeaponworkshopCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new Claypot(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DreamCauldron(helper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(BlastCategory.BLAST_DATA_RECIPE_RECIPE_TYPE, BlastDataRecipe.build());
        registration.addRecipes(WeaponworkshopCategory.WEAPONWORKSHOP_DATA_RECIPE_RECIPE_TYPE, WeaponworkshopDataRecipe.build());
        registration.addRecipes(Claypot.CLAYPOT_DATA_RECIPE_RECIPE_TYPE, ClaypotDataRecipe.build());
        registration.addRecipes(DreamCauldron.DREAM_CAULDRON_RECIPE_RECIPE_TYPE, DreamCauldronRecipe.build());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)PasterdreamModItems.SHADOW_BLAST_FURNACE.get()).m_7968_(), new RecipeType[]{BlastCategory.BLAST_DATA_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(((Item)PasterdreamModItems.WEAPON_WORKSHOP.get()).m_7968_(), new RecipeType[]{WeaponworkshopCategory.WEAPONWORKSHOP_DATA_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(((Item)PasterdreamModItems.CLAYPAN_0.get()).m_7968_(), new RecipeType[]{Claypot.CLAYPOT_DATA_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(((Item)PasterdreamModItems.DREAM_CAULDRON.get()).m_7968_(), new RecipeType[]{DreamCauldron.DREAM_CAULDRON_RECIPE_RECIPE_TYPE});
    }
}

