/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.world;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pasterdream.PasterdreamMod;

@Mod.EventBusSubscriber(modid="pasterdream")
public class VillageBuildingHelper {
    @SubscribeEvent
    public static void serverInitEvent(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        VillageBuildingHelper.registerBuild((StructureTemplatePool)templatePoolRegistry.m_7745_(new ResourceLocation("village/desert/houses")), String.format("%s:desert_cottage_0", "pasterdream"), 200);
    }

    private static void registerBuild(StructureTemplatePool templatePoolRegistry, String building, int weight) {
        List rawTemplates;
        ObjectArrayList templates;
        SinglePoolElement element = (SinglePoolElement)StructurePoolElement.m_210526_((String)building).apply(StructureTemplatePool.Projection.TERRAIN_MATCHING);
        try {
            Field templatesField = StructureTemplatePool.class.getDeclaredField("templates");
            Field rawTemplatesField = StructureTemplatePool.class.getDeclaredField("rawTemplates");
            templatesField.setAccessible(true);
            rawTemplatesField.setAccessible(true);
            templates = (ObjectArrayList)templatesField.get(templatePoolRegistry);
            rawTemplates = (List)rawTemplatesField.get(templatePoolRegistry);
        }
        catch (Exception e) {
            PasterdreamMod.LOGGER.error((Object)e);
            return;
        }
        if (templates == null || rawTemplates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add((Object)element);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(rawTemplates);
        listOfPieceEntries.add(new Pair((Object)element, (Object)weight));
        rawTemplates.clear();
        rawTemplates.addAll(listOfPieceEntries);
    }
}

