/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.client.entity.model;

import com.google.common.collect.ImmutableList;
import dtnpaletteofpaws.common.entity.DTNWolf;
import net.minecraft.class_3532;
import net.minecraft.class_4593;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_7187;

public class DTNWolfModel
extends class_4593<DTNWolf> {
    public class_630 head;
    public class_630 realHead;
    public class_630 body;
    public class_630 mane;
    public class_630 legBackRight;
    public class_630 legBackLeft;
    public class_630 legFrontRight;
    public class_630 legFrontLeft;
    public class_630 tail;
    public class_630 realTail;

    public DTNWolfModel(class_630 box) {
        this.head = box.method_32086("head");
        this.realHead = this.head.method_32086("real_head");
        this.body = box.method_32086("body");
        this.mane = box.method_32086("upper_body");
        this.legBackRight = box.method_32086("right_hind_leg");
        this.legBackLeft = box.method_32086("left_hind_leg");
        this.legFrontRight = box.method_32086("right_front_leg");
        this.legFrontLeft = box.method_32086("left_front_leg");
        this.tail = box.method_32086("tail");
        this.realTail = this.tail.method_32086("real_tail");
    }

    protected Iterable<class_630> method_22946() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.body, (Object)this.legBackLeft, (Object)this.legBackRight, (Object)this.legFrontLeft, (Object)this.legFrontRight, (Object)this.tail, (Object)this.mane);
    }

    public void prepareMobModel(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.resetAllPose();
        if (dog.method_6172()) {
            this.setUpSitPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        } else {
            this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void resetAllPose() {
        this.body.method_41923();
        this.head.method_41923();
        this.legBackLeft.method_41923();
        this.legBackRight.method_41923();
        this.legFrontLeft.method_41923();
        this.legFrontRight.method_41923();
        this.mane.method_41923();
        this.realHead.method_41923();
        this.realTail.method_41923();
        this.tail.method_41923();
    }

    public void setupAnim(DTNWolf dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_3654 += headPitch * ((float)Math.PI / 180);
        this.head.field_3675 += netHeadYaw * ((float)Math.PI / 180);
        this.tail.field_3654 = dog.getTailRotation();
        this.tail.field_3675 = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setUpStandPose(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = class_3532.method_15362((float)(limbSwing * 0.6662f));
        float w1 = class_3532.method_15362((float)(limbSwing * 0.6662f + (float)Math.PI));
        this.legBackRight.field_3654 += w * 1.4f * limbSwingAmount;
        this.legBackLeft.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.field_3654 += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.field_3654 += w * 1.4f * limbSwingAmount;
    }

    public void setUpSitPose(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.method_41920(class_7187.method_41823((float)0.0f, (float)-9.0f, (float)-2.0f));
        this.legFrontLeft.method_41922(class_7187.method_41829((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.method_41920(class_7187.method_41823((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legFrontRight.method_41922(class_7187.method_41829((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.method_41920(class_7187.method_41823((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legBackLeft.method_41922(class_7187.method_41829((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.method_41920(class_7187.method_41823((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.legBackRight.method_41922(class_7187.method_41829((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.method_41920(class_7187.method_41823((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.mane.method_41922(class_7187.method_41829((float)-18.0f, (float)0.0f, (float)0.0f));
        this.mane.method_41920(class_7187.method_41823((float)0.0f, (float)-2.0f, (float)0.0f));
        this.body.method_41922(class_7187.method_41829((float)-45.0f, (float)0.0f, (float)0.0f));
        this.body.method_41920(class_7187.method_41823((float)0.0f, (float)-4.0f, (float)-2.0f));
        this.head.method_41922(class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f));
        this.head.method_41920(class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f));
    }

    public void translateShakingDog(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.field_3674 = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.field_3674 = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.field_3674 = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(DTNWolf dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.field_3674 = dog.getBegAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public static class_5607 createBodyLayer() {
        return DTNWolfModel.createBodyLayerInternal(class_5605.field_27715);
    }

    private static class_5607 createBodyLayerInternal(class_5605 scale) {
        class_5609 var0 = new class_5609();
        class_5610 var1 = var0.method_32111();
        float var2 = 13.5f;
        class_5610 var3 = var1.method_32117("head", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)13.5f, (float)-7.0f));
        class_5610 real_head = var3.method_32117("real_head", class_5606.method_32108().method_32101(0, 0).method_32098(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).method_32101(0, 10).method_32098(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), class_5603.field_27701);
        real_head.method_32117("right_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.method_32117("left_ear", class_5606.method_32108().method_32101(16, 14).method_32098(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new class_5605(0.0f)), class_5603.method_32090((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.method_32117("body", class_5606.method_32108().method_32101(18, 14).method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.method_32117("upper_body", class_5606.method_32108().method_32101(21, 0).method_32098(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), class_5603.method_32091((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        class_5606 var4 = class_5606.method_32108().method_32101(0, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.method_32117("right_hind_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("left_hind_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)7.0f));
        var1.method_32117("right_front_leg", var4, class_5603.method_32090((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.method_32117("left_front_leg", var4, class_5603.method_32090((float)1.5f, (float)16.0f, (float)-4.0f));
        class_5610 var5 = var1.method_32117("tail", class_5606.method_32108(), class_5603.method_32091((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.method_32117("real_tail", class_5606.method_32108().method_32101(9, 18).method_32098(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), class_5603.field_27701);
        return class_5607.method_32110((class_5609)var0, (int)64, (int)32);
    }
}

