/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.spawn;

import dtnpaletteofpaws.DTNEntityTypes;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.util.WolfVariantUtil;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9168;
import net.minecraft.class_9169;

public class DTNWolfSpawnPlacements {
    public static final class_9168 DTN_WOLF_SPAWN_TYPE = new class_9168(){

        public boolean isSpawnPositionOk(class_4538 level, class_2338 pos, @Nullable class_1299<?> type) {
            return DTNWolfSpawnPlacements.spawnPlacementTypeCheck(level, pos, type);
        }
    };

    public static void init() {
        class_1317.method_20637(DTNEntityTypes.DTNWOLF.get(), (class_9168)DTN_WOLF_SPAWN_TYPE, (class_2902.class_2903)class_2902.class_2903.field_13203, DTNWolfSpawnPlacements::DTNWolfSpawnableOn);
    }

    public static boolean DTNWolfSpawnableOn(class_1299<DTNWolf> type, class_1936 level, class_3730 spawn_type, class_2338 pos, class_5819 random) {
        boolean light_condition;
        class_6880 biome = level.method_23753(pos);
        List<WolfBiomeConfig> configs = WolfVariantUtil.getAllWolfBiomeConfigForBiome(level.method_30349(), (class_6880<class_1959>)biome);
        boolean block_is_spawnable = DTNWolfSpawnPlacements.checkWolfSpawnableBlock(level, pos, configs);
        if (!block_is_spawnable) {
            return false;
        }
        boolean bl = light_condition = WolfVariantUtil.checkCanSpawnInTheDarkForConfigs(configs) || DTNWolf.checkWolfSpawnableLight(level, pos);
        return light_condition;
    }

    public static boolean checkWolfSpawnableBlock(class_1936 level, class_2338 pos, List<WolfBiomeConfig> configs) {
        if (DTNWolfSpawnPlacements.checkBasedOnExtraSpawnableBlocksForBiomes(level, pos, configs)) {
            return true;
        }
        return DTNWolf.checkWolfSpawnableBlockDefault(level, pos);
    }

    public static boolean checkBasedOnExtraSpawnableBlocksForBiomes(class_1936 level, class_2338 pos, List<WolfBiomeConfig> configs) {
        class_2680 state_below = level.method_8320(pos.method_10074());
        Set<class_2248> extra_block_set = WolfVariantUtil.getExtraSpawnableBlocksForBiomeConfigs(configs);
        return extra_block_set.contains(state_below.method_26204());
    }

    public static boolean spawnPlacementTypeCheck(class_4538 world, class_2338 pos, class_1299<?> type) {
        if (class_9169.field_48745.isSpawnPositionOk(world, pos, type)) {
            return true;
        }
        return DTNWolfSpawnPlacements.checkPossibleWaterSpawn(world, pos, type);
    }

    private static boolean checkPossibleWaterSpawn(class_4538 world, class_2338 pos, class_1299<?> type) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_26215()) {
            return false;
        }
        class_2338 pos_below = pos.method_10074();
        boolean water_spawnable_below = class_9169.field_48743.isSpawnPositionOk(world, pos_below, type);
        if (!water_spawnable_below) {
            return false;
        }
        class_6880 biome = world.method_23753(pos);
        List configs = WolfVariantUtil.getAllWolfBiomeConfigForBiome(world.method_30349(), (class_6880<class_1959>)biome).stream().filter(x -> x.waterSpawn()).collect(Collectors.toList());
        return !configs.isEmpty();
    }

    public static class_2338 getDTNWolfTopNonCollidingPos(class_1299<DTNWolf> type, class_4538 world, int x, int z) {
        class_2680 below_state;
        class_2338 check_pos_below;
        int inital_height = world.method_8624(class_1317.method_6160(type), x, z);
        class_2338 check_pos = new class_2338(x, inital_height, z);
        if (world.method_8597().comp_643()) {
            while (!world.method_8320(check_pos = check_pos.method_10074()).method_26215()) {
            }
            check_pos_below = check_pos.method_10074();
            while (check_pos_below.method_10264() > world.method_31607() && world.method_8320(check_pos_below).method_26215()) {
                check_pos = check_pos_below;
                check_pos_below = check_pos.method_10074();
            }
        }
        if ((below_state = world.method_8320(check_pos_below = check_pos.method_10074())).method_26171(class_10.field_50) && below_state.method_26227().method_15769()) {
            return check_pos_below;
        }
        return check_pos;
    }
}

