/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.util;

import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.WolfVariants;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class WolfVariantUtil {
    public static WolfVariant getDefault() {
        return WolfVariants.BIRCH.get();
    }

    public static WolfVariant variantFromString(String id) {
        class_2960 res = class_2960.method_12829((String)id);
        if (res == null) {
            return WolfVariantUtil.getDefault();
        }
        WolfVariant variant = (WolfVariant)DTNRegistries.DTN_WOLF_VARIANT.get().method_10223(res);
        if (variant == null) {
            variant = WolfVariantUtil.getDefault();
        }
        return variant;
    }

    public static String variantToString(WolfVariant variant) {
        class_2960 id = DTNRegistries.DTN_WOLF_VARIANT.get().method_10221((Object)variant);
        if (id == null) {
            return DTNRegistries.DTN_WOLF_VARIANT.get().method_10221((Object)WolfVariantUtil.getDefault()).toString();
        }
        return id.toString();
    }

    public static WolfVariant getDefaultForSpawn(DTNWolf wolf, class_5425 s_level_accessor) {
        class_3218 level = s_level_accessor.method_8410();
        if (level != null && level.method_27983().equals(class_1937.field_25180)) {
            return WolfVariants.MOLTEN.get();
        }
        if (WolfVariantUtil.checkWaterSpawn(s_level_accessor, wolf)) {
            return WolfVariants.KOMBU.get();
        }
        return WolfVariantUtil.getDefault();
    }

    private static boolean checkWaterSpawn(class_5425 s_level_accessor, DTNWolf wolf) {
        class_2338 pos = wolf.method_24515();
        class_3610 below_state = s_level_accessor.method_8316(pos.method_10074());
        return below_state.method_15767(class_3486.field_15517);
    }

    public static List<WolfBiomeConfig> getAllWolfBiomeConfigForBiome(class_5455 prov, class_6880<class_1959> biome) {
        class_2378 biome_config_reg = prov.method_30530(WolfBiomeConfigs.regKey());
        List<WolfBiomeConfig> filtered_config = biome_config_reg.method_40270().filter(filter_config -> ((WolfBiomeConfig)filter_config.comp_349()).biomes().method_40241(biome)).map(x -> (WolfBiomeConfig)x.comp_349()).collect(Collectors.toList());
        return filtered_config;
    }

    public static Set<class_2248> getExtraSpawnableBlocksForBiomeConfigs(List<WolfBiomeConfig> configs) {
        HashSet<class_2248> spawnable_block_set = new HashSet<class_2248>();
        for (WolfBiomeConfig config : configs) {
            Set<class_2248> block_list = config.blocks();
            spawnable_block_set.addAll(block_list);
        }
        return spawnable_block_set;
    }

    public static boolean checkCanSpawnInTheDarkForConfigs(List<WolfBiomeConfig> configs) {
        for (WolfBiomeConfig config : configs) {
            if (!config.canSpawnInDark()) continue;
            return true;
        }
        return false;
    }

    public static List<WolfVariant> getPossibleSpawnVariants(class_5819 random, class_5455 prov, class_6880<class_1959> biome) {
        List<WolfBiomeConfig> filtered_config = WolfVariantUtil.getAllWolfBiomeConfigForBiome(prov, biome);
        if (filtered_config.isEmpty()) {
            return List.of();
        }
        if (filtered_config.size() == 1) {
            return new ArrayList<WolfVariant>(filtered_config.get(0).variants());
        }
        int r = random.method_43048(filtered_config.size());
        WolfBiomeConfig selected_config = filtered_config.get(r);
        return new ArrayList<WolfVariant>(selected_config.variants());
    }
}

