/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant;

import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.util.Util;
import java.util.Optional;
import net.minecraft.class_2960;

public class WolfVariant {
    private final class_2960 id;
    private final class_2960 textureLoc;
    private final class_2960 wildTextureLoc;
    private final String translationKey;
    private Optional<class_2960> glowingOverlay;
    private Optional<class_2960> wildGlowingOverlay;
    private boolean fireImmune;
    private boolean fallImmune;
    private boolean swimUnderwater;

    public WolfVariant(Props props) {
        this.id = props.name;
        this.textureLoc = WolfVariant.createTextureLoc(props.name);
        this.wildTextureLoc = WolfVariant.createWildTextureLoc(props.name);
        this.translationKey = WolfVariant.createTranslationKey(props.name);
        this.glowingOverlay = props.glowingOverlay;
        this.wildGlowingOverlay = props.glowingOverlay_wild;
        this.fireImmune = props.fireImmune;
        this.fallImmune = props.fallImmune;
        this.swimUnderwater = props.swimUnderwater;
    }

    private static class_2960 createTextureLoc(class_2960 name) {
        return Util.modifyPath(name, x -> "textures/entity/dtnwolf/variants/wolf_" + x + ".png");
    }

    private static class_2960 createWildTextureLoc(class_2960 name) {
        return Util.modifyPath(name, x -> "textures/entity/dtnwolf/variants/wolf_" + x + "_wild.png");
    }

    private static String createTranslationKey(class_2960 name) {
        return "dtnpaletteofpaws.variant." + name.method_12832();
    }

    public class_2960 id() {
        return this.id;
    }

    public class_2960 texture() {
        return this.textureLoc;
    }

    public class_2960 wildTexture() {
        return this.wildTextureLoc;
    }

    public String translationKey() {
        return this.translationKey;
    }

    public Optional<class_2960> glowingOverlay(boolean wild) {
        if (wild) {
            return this.wildGlowingOverlay;
        }
        return this.glowingOverlay;
    }

    public boolean fireImmune() {
        return this.fireImmune;
    }

    public boolean fallImmune() {
        return this.fallImmune;
    }

    public boolean swimUnderwater() {
        return this.swimUnderwater;
    }

    public void tickWolf(DTNWolf wolf) {
    }

    public static Props props(String name) {
        return new Props(Util.getResource(name));
    }

    public static Props builder(class_2960 name) {
        return new Props(name);
    }

    public static class Props {
        private final class_2960 name;
        private boolean fireImmune;
        private boolean fallImmune;
        private boolean swimUnderwater;
        private Optional<class_2960> glowingOverlay = Optional.empty();
        private Optional<class_2960> glowingOverlay_wild = Optional.empty();

        private Props(class_2960 name) {
            this.name = name;
        }

        public Props fireImmune() {
            this.fireImmune = true;
            return this;
        }

        public Props fallImmune() {
            this.fallImmune = true;
            return this;
        }

        public Props swimUnderwater() {
            this.swimUnderwater = true;
            return this;
        }

        public Props glowingOverlay(class_2960 overlay, class_2960 wild_overlay) {
            if (overlay == null) {
                return this;
            }
            this.glowingOverlay = Optional.of(overlay);
            this.glowingOverlay_wild = Optional.of(wild_overlay);
            return this;
        }
    }
}

