/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.common.variant.biome_config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.common.util.Util;
import dtnpaletteofpaws.common.variant.WolfVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class WolfBiomeConfig {
    private final Set<WolfVariant> variants;
    private final class_6885<class_1959> biomes;
    private final Set<class_2248> extraSpawnableBlocks;
    private final boolean canSpawnInDark;
    private final boolean waterSpawn;
    public static final Codec<WolfBiomeConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Util.deferredCodec(() -> DTNRegistries.DTN_WOLF_VARIANT.get().method_39673()).listOf().optionalFieldOf("variants").forGetter(WolfBiomeConfig::variantsAsList), (App)class_6895.method_40340((class_5321)class_7924.field_41236).fieldOf("biomes").forGetter(WolfBiomeConfig::biomes), (App)class_7923.field_41175.method_39673().listOf().optionalFieldOf("blocks").forGetter(WolfBiomeConfig::blocksAsList), (App)Codec.BOOL.optionalFieldOf("can_spawn_in_dark", (Object)false).forGetter(WolfBiomeConfig::canSpawnInDark), (App)Codec.BOOL.optionalFieldOf("water_spawn", (Object)false).forGetter(WolfBiomeConfig::waterSpawn)).apply((Applicative)builder, WolfBiomeConfig::new));

    public WolfBiomeConfig(List<WolfVariant> variants, class_6885<class_1959> biomes, List<class_2248> blocks, boolean canSpawnInDark, boolean waterSpawn) {
        this.variants = variants == null ? Set.of() : Set.copyOf(variants);
        this.biomes = biomes == null ? class_6885.method_40246((class_6880[])new class_6880[0]) : biomes;
        this.extraSpawnableBlocks = blocks == null ? Set.of() : Set.copyOf(blocks);
        this.canSpawnInDark = canSpawnInDark;
        this.waterSpawn = waterSpawn;
    }

    public WolfBiomeConfig(List<WolfVariant> variants, class_6885<class_1959> biomes, List<class_2248> blocks, boolean canSpawnInDark) {
        this(variants, biomes, blocks, canSpawnInDark, false);
    }

    public WolfBiomeConfig(Optional<List<WolfVariant>> variants, class_6885<class_1959> biomes, Optional<List<class_2248>> blocks, boolean canSpawnInDark, boolean waterSpawn) {
        this(variants.orElse(List.of()), biomes, blocks.orElse(List.of()), canSpawnInDark, waterSpawn);
    }

    public class_6885<class_1959> biomes() {
        return this.biomes;
    }

    public Set<class_2248> blocks() {
        return this.extraSpawnableBlocks;
    }

    public Set<WolfVariant> variants() {
        return this.variants;
    }

    public boolean canSpawnInDark() {
        return this.canSpawnInDark;
    }

    public boolean waterSpawn() {
        return this.waterSpawn;
    }

    public Optional<List<class_2248>> blocksAsList() {
        if (this.extraSpawnableBlocks.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList<class_2248>(this.extraSpawnableBlocks));
    }

    public Optional<List<WolfVariant>> variantsAsList() {
        if (this.variants.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArrayList<WolfVariant>(this.variants));
    }
}

