/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws.dtn_support;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.event.EventHandler;
import doggytalents.forge_imitate.event.PlayerInteractEvent;
import dtnpaletteofpaws.common.entity.DTNWolf;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.dtn_support.variant.DTNDogVariantMapping;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class DTNSupportEventHandler {
    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        class_1937 level = event.getLevel();
        class_1799 stack = event.getItemStack();
        class_1297 target = event.getTarget();
        class_1657 owner = event.getEntity();
        if (stack.method_7909() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!(target instanceof DTNWolf)) {
            return;
        }
        DTNWolf wolf = (DTNWolf)target;
        event.setCanceled(true);
        if (!DTNSupportEventHandler.checkValidWolf(wolf, owner)) {
            event.setCancellationResult(class_1269.field_5814);
            return;
        }
        if (!level.field_9236) {
            DTNSupportEventHandler.checkAndTrainWolf(owner, wolf);
        }
        event.setCancellationResult(class_1269.field_5812);
    }

    public static void checkAndTrainWolf(class_1657 trainer, DTNWolf wolf) {
        class_1937 level = trainer.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 stack = trainer.method_6047();
        if (stack.method_7909() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!DTNSupportEventHandler.checkValidWolf(wolf, trainer)) {
            return;
        }
        if (!EventHandler.isWithinTrainWolfLimit((class_1657)trainer)) {
            level.method_8421((class_1297)wolf, (byte)6);
            return;
        }
        if (!trainer.method_31549().field_7477) {
            stack.method_7934(1);
        }
        DTNSupportEventHandler.tameWolfIfNeccessary(wolf, trainer);
        DTNSupportEventHandler.trainWolf(wolf, trainer, level);
    }

    private static boolean checkValidWolf(DTNWolf wolf, class_1657 owner) {
        if (!wolf.method_5805()) {
            return false;
        }
        boolean condition1 = !wolf.method_6181();
        boolean condition2 = wolf.method_6181() && wolf.method_6171((class_1309)owner);
        return condition1 || condition2;
    }

    public static void tameWolfIfNeccessary(DTNWolf wolf, class_1657 owner) {
        if (wolf.method_6181()) {
            return;
        }
        wolf.method_6170(owner);
    }

    public static void trainWolf(DTNWolf wolf, class_1657 owner, class_1937 level) {
        Dog dog = (Dog)((class_1299)DoggyEntityTypes.DOG.get()).method_5883(level);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.method_6173(true, true);
        dog.method_6174(owner.method_5667());
        dog.maxHealth();
        dog.method_24346(false);
        dog.method_5614(wolf.method_5618());
        dog.method_5808(wolf.method_23317(), wolf.method_23318(), wolf.method_23321(), wolf.method_36454(), wolf.method_36455());
        dog.method_5847(wolf.field_6283);
        dog.method_5636(wolf.field_6283);
        dog.method_36456(wolf.field_6283);
        class_1767 wolf_collar_color = wolf.getCollarColor();
        int color = wolf_collar_color.method_7787();
        AccessoryInstance dog_collar = ((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        DTNSupportEventHandler.migrateWolfVariant(wolf, dog);
        DTNSupportEventHandler.migrateWolfArmor(wolf, dog);
        if (wolf.method_16914()) {
            dog.setDogCustomName(wolf.method_5797());
        }
        UUID wolf_uuid = wolf.method_5667();
        wolf.method_31472();
        if (level instanceof class_3218) {
            class_3218 sL = (class_3218)level;
            DTNSupportEventHandler.migrateUUID(wolf_uuid, dog, sL);
        }
        level.method_8649((class_1297)dog);
        dog.triggerAnimationAction((AnimationAction)new DogBackFlipAction(dog));
        dog.method_5993().method_6233();
    }

    private static void migrateUUID(UUID uuid, Dog dog, class_3218 level) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return;
        }
        if (level.method_14190(uuid) != null) {
            return;
        }
        dog.method_5826(uuid);
    }

    private static void migrateWolfVariant(DTNWolf wolf, Dog dog) {
        WolfVariant variant = wolf.getVariant();
        dog.setDogVariant(DTNDogVariantMapping.getDTNWolf(variant));
    }

    private static void migrateWolfArmor(DTNWolf wolf, Dog dog) {
        if (!wolf.hasWolfArmor()) {
            return;
        }
        class_1799 armor_stack = wolf.method_56676().method_46651(1);
        dog.setWolfArmor(armor_stack);
    }
}

