/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.genielamp.client.gui.screens;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.registries.ForgeRegistries;
import net.tejty.genielamp.block.ModBlocks;
import net.tejty.genielamp.config.GenieLampCommonConfigs;
import net.tejty.genielamp.networking.ModMessages;
import net.tejty.genielamp.networking.packet.ItemWishingC2SPacket;
import net.tejty.genielamp.world.inventory.GenieLampMenu;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WishingScreen
extends AbstractContainerScreen<GenieLampMenu> {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("genie_lamp:textures/gui/wishing_screen.png");
    private static final int FILE_WIDTH = 256;
    private static final int FILE_HEIGHT = 256;
    private static final int ROWS = 7;
    private static final int COLUMNS = 9;
    private static final int SLOT_SIZE = 18;
    private static final int ITEM_SIZE = 16;
    private static final int CONTENT_PADDING_LEFT = 9;
    private static final int CONTENT_PADDING_RIGHT = 26;
    private static final int CONTENT_PADDING_TOP = 18;
    private static final int CONTENT_PADDING_BOTTOM = 8;
    private static final int SLIDER_PADDING_LEFT = 177;
    private static final int SLIDER_WIDTH = 12;
    private static final int SLIDER_HEIGHT = 15;
    private static final int SLIDER_BAR_HEIGHT = 126;
    private static final int SLIDER_X = 197;
    private static final int SLIDER_Y = 0;
    private static final int SEARCH_BOX_PADDING_LEFT = 84;
    private static final int SEARCH_BOX_PADDING_TOP = 6;
    private static final int SEARCH_BOX_WIDTH = 88;
    private static final int SEARCH_BOX_HEIGHT = 10;
    private final Level level;
    public static Player player;
    private final BlockPos lampPos;
    private static Collection<ItemStack> items;
    private static Collection<Item> unsortedItems;
    private static Collection<ItemStack> unsortedItemsFromTab;
    private int scrollOff;
    private boolean isDragging;
    private EditBox searchBox;

    private int getCenterX() {
        return this.f_96543_ / 2;
    }

    private int getCenterY() {
        return this.f_96544_ / 2;
    }

    private int getContentWidth() {
        return 162;
    }

    private int getContentHeight() {
        return 126;
    }

    private int getContentCornerX() {
        return this.getCenterX() - this.getBackgroundWidth() / 2 + 9;
    }

    private int getContentCornerY() {
        return this.getCenterY() - this.getBackgroundHeight() / 2 + 18;
    }

    private int getBackgroundCornerX() {
        return this.getContentCornerX() - 9;
    }

    private int getBackgroundCornerY() {
        return this.getContentCornerY() - 18;
    }

    private int getBackgroundWidth() {
        return this.getContentWidth() + 9 + 26;
    }

    private int getBackgroundHeight() {
        return this.getContentHeight() + 18 + 8;
    }

    private int getSlotPadding() {
        return 1;
    }

    private int getSliderRange() {
        return 111;
    }

    public WishingScreen(GenieLampMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.level = inventory.f_35978_.m_9236_();
        player = inventory.f_35978_;
        this.lampPos = new BlockPos(container.x, container.y, container.z);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)true, (HolderLookup.Provider)player.m_9236_().m_9598_());
        this.createScreen();
    }

    private void createScreen() {
        CreativeModeTab tab = CreativeModeTabRegistry.getTab((ResourceLocation)new ResourceLocation("search"));
        List<Item> bannedItems = ((List)GenieLampCommonConfigs.BANNED_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).toList();
        unsortedItemsFromTab = tab.m_260957_().stream().filter(stack -> !bannedItems.contains(stack.m_41720_())).collect(Collectors.toList());
        items = unsortedItemsFromTab;
        this.searchBox = new EditBox(this.f_96547_, this.getBackgroundCornerX() + 84, this.getBackgroundCornerY() + 6, 88, 10, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94190_(false);
        this.searchBox.m_93692_(true);
        this.m_7787_((GuiEventListener)this.searchBox);
    }

    public void m_181908_() {
        this.searchBox.m_94120_();
        if (!this.level.m_8055_(this.lampPos).m_60713_((Block)ModBlocks.CHARGED_MAGIC_LAMP.get())) {
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && pKeyCode != 256 || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280398_(BACKGROUND_LOCATION, this.getBackgroundCornerX(), this.getBackgroundCornerY(), 0, 0.0f, 0.0f, this.getBackgroundWidth(), this.getBackgroundHeight(), 256, 256);
        for (int itemValue = 0; itemValue < 63; ++itemValue) {
            try {
                int x = itemValue % 9 * 18 + this.getContentCornerX();
                int y = (itemValue - itemValue % 9) / 9 * 18 + this.getContentCornerY();
                ItemStack stack = (ItemStack)items.toArray()[itemValue + this.scrollOff * 9];
                graphics.m_280480_(stack, x + this.getSlotPadding(), y + this.getSlotPadding());
                if (mouseX < x + this.getSlotPadding() || mouseX > x + 16 + this.getSlotPadding() || mouseY < y + this.getSlotPadding() || mouseY > y + 16 + this.getSlotPadding()) continue;
                graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
                graphics.m_280509_(x, y, x + 18, y + 18, FastColor.ARGB32.m_13660_((int)100, (int)200, (int)200, (int)200));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"wishing_screen.title"), this.getBackgroundCornerX() + 9, this.getBackgroundCornerY() + 6, FastColor.ARGB32.m_13660_((int)255, (int)63, (int)63, (int)63), false);
        this.searchBox.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderSlider(graphics);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
    }

    private void renderSlider(GuiGraphics pGuiGraphics) {
        int sliderPoints = (int)Math.ceil((double)items.size() / 9.0) - 7;
        if (sliderPoints > 1) {
            int sliderShift = this.getSliderRange() * this.scrollOff / sliderPoints;
            int sliderPosY = this.getBackgroundCornerY() + 18 + sliderShift;
            pGuiGraphics.m_280398_(BACKGROUND_LOCATION, this.getBackgroundCornerX() + 177, sliderPosY, 0, 197.0f, 0.0f, 12, 15, 256, 256);
        } else {
            pGuiGraphics.m_280398_(BACKGROUND_LOCATION, this.getBackgroundCornerX() + 177, this.getBackgroundCornerY() + 18, 0, 209.0f, 0.0f, 12, 15, 256, 256);
        }
    }

    private boolean canScroll(int pNumRows) {
        return pNumRows > 7;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        int i = (int)Math.ceil((double)items.size() / 9.0);
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.m_14045_((int)((int)((double)this.scrollOff - pDelta)), (int)0, (int)j);
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int rows = (int)Math.ceil((double)items.size() / 9.0);
        if (this.isDragging) {
            int top = this.getBackgroundCornerY() + 18;
            int bottom = top + 126;
            int sliderPoints = rows - 7;
            float f = ((float)pMouseY - (float)top - 7.5f) / ((float)(bottom - top) - 15.0f);
            f = f * (float)sliderPoints + 0.5f;
            this.scrollOff = Mth.m_14045_((int)((int)f), (int)0, (int)sliderPoints);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        int left = this.getBackgroundCornerX() + 177;
        int top = this.getBackgroundCornerY() + 18;
        int right = left + 12;
        int bottom = top + 126;
        int rows = (int)Math.ceil((double)items.size() / 9.0);
        if (this.canScroll(rows) && pMouseX > (double)left && pMouseX < (double)right && pMouseY > (double)top && pMouseY <= (double)bottom) {
            this.isDragging = true;
        }
        if (pMouseX > (double)this.getContentCornerX() && pMouseX < (double)(this.getContentCornerX() + this.getContentWidth()) && pMouseY > (double)this.getContentCornerY() && pMouseY < (double)(this.getContentCornerY() + this.getContentHeight())) {
            int x = (int)pMouseX - this.getContentCornerX();
            int y = (int)pMouseY - this.getContentCornerY();
            int slotX = (int)((float)x / 18.0f);
            int slotY = (int)((float)y / 18.0f);
            try {
                ItemStack stack = ((ItemStack)items.toArray()[slotY * 9 + slotX + this.scrollOff * 9]).m_41777_();
                if (this.level.m_8055_(this.lampPos).m_60713_((Block)ModBlocks.CHARGED_MAGIC_LAMP.get())) {
                    ModMessages.sendToServer(new ItemWishingC2SPacket(stack, this.lampPos));
                    Minecraft.m_91087_().f_91063_.m_109113_(stack);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException ignored) {
                return false;
            }
            Minecraft.m_91087_().m_91152_((Screen)null);
            return false;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private void refreshSearchResults() {
        items = unsortedItemsFromTab.stream().filter(item -> StringUtils.toLowerCase((String)ForgeI18n.stripControlCodes((String)item.m_41720_().m_7626_(item).getString())).contains(StringUtils.toLowerCase((String)this.searchBox.m_94155_()))).collect(Collectors.toList());
        this.scrollOff = 0;
    }

    private Button openScreenButton(Component component, Supplier<Screen> screenSupplier) {
        return Button.m_253074_((Component)component, p_280817_ -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_((Screen)screenSupplier.get());
        }).m_252780_(98).m_253136_();
    }

    private Button openLinkButton(Component component, String uri) {
        return this.openScreenButton(component, () -> new ConfirmLinkScreen(p_280813_ -> {
            if (p_280813_) {
                Util.m_137581_().m_137646_(uri);
            }
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_((Screen)this);
        }, uri, true));
    }
}

