/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.genielamp.networking.packet;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tejty.genielamp.block.ModBlocks;
import net.tejty.genielamp.config.GenieLampCommonConfigs;

public class ItemWishingC2SPacket {
    private final ItemStack stack;
    private final BlockPos pos;

    public ItemWishingC2SPacket(ItemStack stack, BlockPos pos) {
        this.stack = stack;
        this.pos = pos;
    }

    public ItemWishingC2SPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.pos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            if (level.m_8055_(this.pos).m_60713_((Block)ModBlocks.CHARGED_MAGIC_LAMP.get())) {
                List<Item> bannedItems = ((List)GenieLampCommonConfigs.BANNED_ITEMS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).toList();
                if (bannedItems.contains(this.stack.m_41720_())) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity((Level)level, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.3, (double)this.pos.m_123343_() + 0.5, this.stack);
                itemEntity.m_32010_(60);
                itemEntity.m_6001_(0.0, 0.05, 0.0);
                level.m_7967_((Entity)itemEntity);
                level.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 3);
                level.m_8767_((ParticleOptions)ParticleTypes.f_175827_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_(), (double)this.pos.m_123343_() + 0.5, 50, 0.0, 0.0, 0.0, 0.3);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123776_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.3, (double)this.pos.m_123343_() + 0.5, 100, 0.3, 0.3, 0.3, 1.0);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.3, (double)this.pos.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, 0.1);
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.3, (double)this.pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.3, (double)this.pos.m_123343_() + 0.5, 10, 0.0, 0.2, 0.0, 0.0);
                level.m_5594_(null, this.pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 2.0f, 0.5f);
            }
        });
        return true;
    }
}

