/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidbound.endbiomes;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mcreator.voidbound.endbiomes.SamplerHooks;
import net.mcreator.voidbound.endbiomes.WeightedPicker;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public final class TheEndBiomeData {
    public static final ThreadLocal<HolderGetter<Biome>> biomeRegistry = new ThreadLocal();
    public static final Set<ResourceKey<Biome>> ADDED_BIOMES = new HashSet<ResourceKey<Biome>>();
    private static final Map<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>> END_BIOMES_MAP = new IdentityHashMap<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>>();
    private static final Map<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>> END_MIDLANDS_MAP = new IdentityHashMap<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>>();
    private static final Map<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>> END_BARRENS_MAP = new IdentityHashMap<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>>();
    public static List<List<Object>> endBiomes = new ArrayList<List<Object>>();
    public static List<List<Object>> midlandsBiomes = new ArrayList<List<Object>>();
    public static List<List<Object>> barrensBiomes = new ArrayList<List<Object>>();

    private TheEndBiomeData() {
    }

    public static void addEndBiomeReplacement(ResourceKey<Biome> replaced, ResourceKey<Biome> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced entry is null");
        Preconditions.checkNotNull(variant, (Object)"variant entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedPicker()).add(variant, weight);
        ADDED_BIOMES.add(variant);
    }

    public static void addEndMidlandsReplacement(ResourceKey<Biome> highlands, ResourceKey<Biome> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(midlands, weight);
        ADDED_BIOMES.add(midlands);
    }

    public static void addEndBarrensReplacement(ResourceKey<Biome> highlands, ResourceKey<Biome> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(barrens, weight);
        ADDED_BIOMES.add(barrens);
    }

    public static Overrides createOverrides(HolderGetter<Biome> biomeRegistry) {
        return new Overrides(biomeRegistry);
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((ResourceKey<Biome>)Biomes.f_48210_, key -> new WeightedPicker()).add(Biomes.f_48210_, 1.0);
        END_BIOMES_MAP.computeIfAbsent((ResourceKey<Biome>)Biomes.f_48164_, key -> new WeightedPicker()).add(Biomes.f_48164_, 1.0);
        END_BIOMES_MAP.computeIfAbsent((ResourceKey<Biome>)Biomes.f_48162_, key -> new WeightedPicker()).add(Biomes.f_48162_, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((ResourceKey<Biome>)Biomes.f_48164_, key -> new WeightedPicker()).add(Biomes.f_48163_, 1.0);
        END_BARRENS_MAP.computeIfAbsent((ResourceKey<Biome>)Biomes.f_48164_, key -> new WeightedPicker()).add(Biomes.f_48165_, 1.0);
    }

    public static class Overrides {
        public final Set<Holder<Biome>> customBiomes;
        HolderGetter<Biome> biomeRegistryInstance;
        public final Holder<Biome> endMidlands;
        public final Holder<Biome> endBarrens;
        public final Holder<Biome> endHighlands;
        @Nullable
        public Map<Holder<Biome>, WeightedPicker<Holder<Biome>>> endBiomesMap;
        @Nullable
        public Map<Holder<Biome>, WeightedPicker<Holder<Biome>>> endMidlandsMap;
        @Nullable
        public Map<Holder<Biome>, WeightedPicker<Holder<Biome>>> endBarrensMap;
        private final Map<Climate.Sampler, ImprovedNoise> samplers = new WeakHashMap<Climate.Sampler, ImprovedNoise>();
        public List<List<Object>> endBiomesCopy = new ArrayList<List<Object>>();
        public List<List<Object>> midlandsBiomesCopy = new ArrayList<List<Object>>();
        public List<List<Object>> barrensBiomesCopy = new ArrayList<List<Object>>();

        public Overrides(HolderGetter<Biome> biomeRegistry) {
            this.customBiomes = ADDED_BIOMES.stream().map(arg_0 -> biomeRegistry.m_255043_(arg_0)).collect(Collectors.toSet());
            this.endMidlands = biomeRegistry.m_255043_(Biomes.f_48163_);
            this.endBarrens = biomeRegistry.m_255043_(Biomes.f_48165_);
            this.endHighlands = biomeRegistry.m_255043_(Biomes.f_48164_);
            this.endBiomesCopy = List.copyOf(endBiomes);
            this.midlandsBiomesCopy = List.copyOf(midlandsBiomes);
            this.barrensBiomesCopy = List.copyOf(barrensBiomes);
            this.biomeRegistryInstance = biomeRegistry;
        }

        public void addExternalModBiomes(List<List<Object>> biomes, String type) {
            block4: {
                block5: {
                    block3: {
                        if (!type.equals("end")) break block3;
                        for (List<Object> biome : biomes) {
                            TheEndBiomeData.addEndBiomeReplacement((ResourceKey<Biome>)((ResourceKey)biome.get(0)), (ResourceKey<Biome>)((ResourceKey)biome.get(1)), (Double)biome.get(2));
                        }
                        break block4;
                    }
                    if (!type.equals("midlands")) break block5;
                    for (List<Object> biome : biomes) {
                        TheEndBiomeData.addEndMidlandsReplacement((ResourceKey<Biome>)((ResourceKey)biome.get(0)), (ResourceKey<Biome>)((ResourceKey)biome.get(1)), (Double)biome.get(2));
                    }
                    break block4;
                }
                if (!type.equals("barrens")) break block4;
                for (List<Object> biome : biomes) {
                    TheEndBiomeData.addEndBarrensReplacement((ResourceKey<Biome>)((ResourceKey)biome.get(0)), (ResourceKey<Biome>)((ResourceKey)biome.get(1)), (Double)biome.get(2));
                }
            }
        }

        public void initBiomes() {
            this.endBiomesMap = this.resolveOverrides(this.biomeRegistryInstance, END_BIOMES_MAP, (ResourceKey<Biome>)Biomes.f_48210_);
            this.endMidlandsMap = this.resolveOverrides(this.biomeRegistryInstance, END_MIDLANDS_MAP, (ResourceKey<Biome>)Biomes.f_48163_);
            this.endBarrensMap = this.resolveOverrides(this.biomeRegistryInstance, END_BARRENS_MAP, (ResourceKey<Biome>)Biomes.f_48165_);
        }

        @Nullable
        private Map<Holder<Biome>, WeightedPicker<Holder<Biome>>> resolveOverrides(HolderGetter<Biome> biomeRegistry, Map<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>> overrides, ResourceKey<Biome> vanillaKey) {
            Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap(overrides.size(), (Hash.Strategy)RegistryKeyHashStrategy.INSTANCE);
            for (Map.Entry<ResourceKey<Biome>, WeightedPicker<ResourceKey<Biome>>> entry : overrides.entrySet()) {
                WeightedPicker<ResourceKey<Biome>> picker = entry.getValue();
                int count = picker.getEntryCount();
                if (count == 0 || count == 1 && entry.getKey() == vanillaKey) continue;
                result.put(biomeRegistry.m_255043_(entry.getKey()), picker.map(arg_0 -> biomeRegistry.m_255043_(arg_0)));
            }
            return result.isEmpty() ? null : result;
        }

        public Holder<Biome> pick(int x, int y, int z, Climate.Sampler noise, Holder<Biome> vanillaBiome) {
            block5: {
                boolean isMidlands;
                block4: {
                    isMidlands = vanillaBiome.m_203425_(arg_0 -> this.endMidlands.m_203565_(arg_0));
                    if (isMidlands) break block4;
                    if (!vanillaBiome.m_203425_(arg_0 -> this.endBarrens.m_203565_(arg_0))) break block5;
                }
                Holder<Biome> highlandsReplacement = this.pick(this.endHighlands, this.endHighlands, this.endBiomesMap, x, z, noise);
                Map<Holder<Biome>, WeightedPicker<Holder<Biome>>> map = isMidlands ? this.endMidlandsMap : this.endBarrensMap;
                return this.pick(highlandsReplacement, vanillaBiome, map, x, z, noise);
            }
            assert (END_BIOMES_MAP.containsKey(vanillaBiome.m_203543_().orElseThrow()));
            return this.pick(vanillaBiome, vanillaBiome, this.endBiomesMap, x, z, noise);
        }

        private <T extends Holder<Biome>> T pick(T key, T defaultValue, Map<T, WeightedPicker<T>> pickers, int x, int z, Climate.Sampler noise) {
            WeightedPicker<T> picker;
            block6: {
                block5: {
                    if (pickers == null) {
                        return defaultValue;
                    }
                    picker = pickers.get(key);
                    if (picker == null) {
                        return defaultValue;
                    }
                    int count = picker.getEntryCount();
                    if (count == 0) break block5;
                    if (count != 1) break block6;
                    if (!key.m_203425_(arg_0 -> this.endHighlands.m_203565_(arg_0))) break block6;
                }
                return defaultValue;
            }
            return (T)((Holder)picker.pickFromNoise(((SamplerHooks)noise).getEndBiomesSampler(), (double)x / 64.0, 0.0, (double)z / 64.0));
        }
    }

    static enum RegistryKeyHashStrategy implements Hash.Strategy<Holder<?>>
    {
        INSTANCE;


        public boolean equals(Holder<?> a, Holder<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.m_203376_() != b.m_203376_()) {
                return false;
            }
            return (Boolean)a.m_203439_().map(key -> b.m_203543_().get() == key, b.m_203334_()::equals);
        }

        public int hashCode(Holder<?> a) {
            if (a == null) {
                return 0;
            }
            return (Integer)a.m_203439_().map(System::identityHashCode, Object::hashCode);
        }
    }
}

