/*
 * Decompiled with CFR 0.152.
 */
package afterdeathmod.entity;

import afterdeathmod.init.AfterdeathModEntities;
import afterdeathmod.procedures.SitClickProcedure;
import afterdeathmod.procedures.SpawnSpiritWolfProcedure;
import java.util.EnumSet;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SpiritWolfEntity
extends PathfinderMob {
    public SpiritWolfEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SpiritWolfEntity>)((EntityType)AfterdeathModEntities.SPIRIT_WOLF.get()), world);
    }

    public SpiritWolfEntity(EntityType<SpiritWolfEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 0.6f;
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 3.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_}), false));
        this.f_21345_.m_25352_(2, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return SpiritWolfEntity.this.m_5448_() != null && !SpiritWolfEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return SpiritWolfEntity.this.m_21566_().m_24995_() && SpiritWolfEntity.this.m_5448_() != null && SpiritWolfEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = SpiritWolfEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                SpiritWolfEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = SpiritWolfEntity.this.m_5448_();
                if (SpiritWolfEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    SpiritWolfEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = SpiritWolfEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        SpiritWolfEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal(this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 2.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50016_.m_5456_()}), false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, true));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("afterdeath:spirthurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wolf.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        SpawnSpiritWolfProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof Player) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268565_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        super.m_6071_(sourceentity, hand);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        SpiritWolfEntity entity = this;
        Level world = this.f_19853_;
        SitClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return retval;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        return builder;
    }
}

