/*
 * Decompiled with CFR 0.152.
 */
package hotsuop.momovement;

import hotsuop.momovement.IMoMovementInput;
import hotsuop.momovement.IMoPlayer;
import hotsuop.momovement.IMoveStateUpdater;
import hotsuop.momovement.MoveState;
import hotsuop.momovement.api.SoundRegistry;
import hotsuop.momovement.config.IMoMovementConfig;
import hotsuop.momovement.config.MoMovementConfig;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoMovement
implements ModInitializer {
    public static final String MOD_ID = "momovement";
    protected static MoMovementConfig serverConfig = null;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"momovement");
    public static final class_2960 MOVE_STATE = new class_2960("momovement", "move_state");
    public static final class_2960 CONFIG_STATE = new class_2960("momovement", "config_state");
    private static final Object _queueLock = new Object();
    private static final Queue<Runnable> _actionQueue = new LinkedList<Runnable>();
    public static IMoveStateUpdater moveStateUpdater;
    public static IMoMovementInput INPUT;
    public static IMoMovementConfig CONFIG;

    public static MoMovementConfig getConfig() {
        if (serverConfig != null) {
            return serverConfig;
        }
        return CONFIG.getConfig();
    }

    public void onInitialize() {
        SoundRegistry.registerSound();
        moveStateUpdater = new IMoveStateUpdater(){

            @Override
            public void setMoveState(class_1657 player, MoveState moveState) {
            }

            @Override
            public void setAnimationState(class_1657 player, MoveState moveState) {
            }
        };
        INPUT = new IMoMovementInput(){

            @Override
            public boolean ismoveUpKeyPressed() {
                return false;
            }

            @Override
            public boolean ismoveDownKeyPressed() {
                return false;
            }

            @Override
            public boolean ismoveUpKeyPressedLastTick() {
                return false;
            }

            @Override
            public boolean ismoveDownKeyPressedLastTick() {
                return false;
            }
        };
        CONFIG = MoMovementConfig::new;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MOVE_STATE, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            int moveStateInt = buf.readInt();
            MoveState moveState = MoveState.STATE(moveStateInt);
            IMoPlayer moPlayer = (IMoPlayer)server.method_3760().method_14602(uuid);
            if (moPlayer != null) {
                moPlayer.momovement_setMoveState(moveState);
            }
            MoMovement.SendToClients((class_1657)moPlayer, MOVE_STATE, uuid, moveStateInt);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Object object = _queueLock;
            synchronized (object) {
                while (_actionQueue.size() > 0) {
                    _actionQueue.poll().run();
                }
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_52964(MoMovement.getConfig().enableMoMovement);
            buf.method_52964(MoMovement.getConfig().diveRollEnabled);
            buf.method_53002(MoMovement.getConfig().diveRollStaminaCost);
            buf.method_52940(MoMovement.getConfig().diveRollSpeedBoostMultiplier);
            buf.method_53002(MoMovement.getConfig().diveRollCoolDown);
            buf.method_52964(MoMovement.getConfig().diveRollWhenSwimming);
            buf.method_52964(MoMovement.getConfig().diveRollWhenFlying);
            buf.method_52964(MoMovement.getConfig().wallRunEnabled);
            buf.method_53002(MoMovement.getConfig().wallRunStaminaCost);
            buf.method_52940(MoMovement.getConfig().wallRunSpeedBoostMultiplier);
            buf.method_53002(MoMovement.getConfig().wallRunDurationTicks);
            buf.method_52964(MoMovement.getConfig().slideEnabled);
            buf.method_53002(MoMovement.getConfig().slideStaminaCost);
            buf.method_52940(MoMovement.getConfig().slideSpeedBoostMultiplier);
            buf.method_53002(MoMovement.getConfig().slideCoolDown);
            sender.sendPacket(CONFIG_STATE, buf);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SendToClients(class_1657 source, class_2960 type, UUID uuid, int moveStateInt) {
        Object object = _queueLock;
        synchronized (object) {
            _actionQueue.add(() -> {
                for (class_1657 target : source.method_5682().method_3760().method_14571()) {
                    if (target == source || !(target.method_5858((class_1297)source) < 6400.0)) continue;
                    class_2540 buf = PacketByteBufs.create();
                    buf.method_10797(uuid);
                    buf.method_53002(moveStateInt);
                    ServerPlayNetworking.send((class_3222)((class_3222)target), (class_2960)type, (class_2540)buf);
                }
            });
        }
    }
}

