/*
 * Decompiled with CFR 0.152.
 */
package hotsuop.momovement.client;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import hotsuop.momovement.IAnimatedPlayer;
import hotsuop.momovement.IMoPlayer;
import hotsuop.momovement.IMoveStateUpdater;
import hotsuop.momovement.MoMovement;
import hotsuop.momovement.MoveState;
import hotsuop.momovement.client.MoMovementInput;
import hotsuop.momovement.config.MoMovementConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.uku3lig.ukulib.config.ConfigManager;

public class MoMovementClient
extends MoMovement
implements ClientModInitializer {
    private static final Map<String, KeyframeAnimation> _animations = new HashMap<String, KeyframeAnimation>();
    public static final ConfigManager<MoMovementConfig> CONFIG_MANAGER = ConfigManager.createDefault(MoMovementConfig.class, (String)"momovement");

    public void onInitializeClient() {
        LOGGER.info("initializing MoMovement Client :3");
        MoMovementInput input = new MoMovementInput();
        INPUT = input;
        ClientTickEvents.END_CLIENT_TICK.register(input::onEndTick);
        moveStateUpdater = new IMoveStateUpdater(){

            @Override
            public void setMoveState(class_1657 player, MoveState moveState) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10797(player.method_5667());
                buf.method_53002(MoveState.STATE(moveState));
                ClientPlayNetworking.send((class_2960)MoMovement.MOVE_STATE, (class_2540)buf);
            }

            @Override
            public void setAnimationState(class_1657 player, MoveState moveState) {
                if (!(player instanceof IAnimatedPlayer)) {
                    return;
                }
                IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)player;
                ModifierLayer<IAnimation> animationContainer = animatedPlayer.momovement_getModAnimation();
                ModifierLayer<IAnimation> animationBodyContainer = animatedPlayer.momovement_getModAnimationBody();
                if (animationContainer == null || animationBodyContainer == null) {
                    return;
                }
                if (_animations.isEmpty()) {
                    for (MoveState entry : MoveState.STATES.values()) {
                        KeyframeAnimation animation;
                        String name = entry.name;
                        if (name.equals("none") || (animation = PlayerAnimationRegistry.getAnimation((class_2960)new class_2960("momovement", entry.name))) == null) continue;
                        _animations.put(entry.name, animation);
                    }
                }
                AbstractFadeModifier fade = AbstractFadeModifier.standardFadeIn((int)10, (Ease)Ease.INOUTQUAD);
                KeyframeAnimation anim = _animations.get(moveState.name);
                if (anim == null) {
                    animationBodyContainer.replaceAnimationWithFade(fade, null);
                    animationContainer.replaceAnimationWithFade(fade, null);
                    return;
                }
                KeyframeAnimationPlayer bodyLayer = new KeyframeAnimationPlayer(anim);
                KeyframeAnimationPlayer.BodyPart bodyVal = (KeyframeAnimationPlayer.BodyPart)bodyLayer.bodyParts.get("body");
                bodyLayer.bodyParts.clear();
                bodyLayer.bodyParts.put("body", bodyVal);
                animationBodyContainer.replaceAnimationWithFade(fade, (IAnimation)bodyLayer);
                animationContainer.replaceAnimationWithFade(fade, (IAnimation)new KeyframeAnimationPlayer(anim));
            }
        };
        CONFIG = () -> CONFIG_MANAGER.getConfig();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MoMovement.MOVE_STATE, (client, handler, buf, responseSender) -> {
            if (client.field_1687 != null) {
                UUID uuid = buf.method_10790();
                int moveStateInt = buf.readInt();
                MoveState moveState = MoveState.STATE(moveStateInt);
                IMoPlayer moPlayer = (IMoPlayer)client.field_1687.method_18470(uuid);
                if (moPlayer != null) {
                    moPlayer.momovement_setMoveState(moveState);
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MoMovement.CONFIG_STATE, (client, handler, buf, responseSender) -> {
            serverConfig = new MoMovementConfig();
            MoMovementClient.serverConfig.enableMoMovement = buf.readBoolean();
            MoMovementClient.serverConfig.diveRollEnabled = buf.readBoolean();
            MoMovementClient.serverConfig.diveRollStaminaCost = buf.readInt();
            MoMovementClient.serverConfig.diveRollSpeedBoostMultiplier = buf.readDouble();
            MoMovementClient.serverConfig.diveRollCoolDown = buf.readInt();
            MoMovementClient.serverConfig.diveRollWhenSwimming = buf.readBoolean();
            MoMovementClient.serverConfig.diveRollWhenFlying = buf.readBoolean();
            MoMovementClient.serverConfig.wallRunEnabled = buf.readBoolean();
            MoMovementClient.serverConfig.wallRunStaminaCost = buf.readInt();
            MoMovementClient.serverConfig.wallRunSpeedBoostMultiplier = buf.readDouble();
            MoMovementClient.serverConfig.wallRunDurationTicks = buf.readInt();
            MoMovementClient.serverConfig.slideEnabled = buf.readBoolean();
            MoMovementClient.serverConfig.slideStaminaCost = buf.readInt();
            MoMovementClient.serverConfig.slideSpeedBoostMultiplier = buf.readDouble();
            MoMovementClient.serverConfig.slideCoolDown = buf.readInt();
            LOGGER.info("Got config from server");
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            serverConfig = null;
        });
    }
}

