/*
 * Decompiled with CFR 0.152.
 */
package hotsuop.momovement.mixin;

import hotsuop.momovement.IMoPlayer;
import hotsuop.momovement.MoMovement;
import hotsuop.momovement.MoveState;
import hotsuop.momovement.api.SoundRegistry;
import hotsuop.momovement.config.MoMovementConfig;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8112;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IMoPlayer {
    @Shadow
    @Final
    private static Logger field_38197;
    @Shadow
    @Final
    private class_1656 field_7503;
    @Shadow
    protected class_1702 field_7493;
    @Unique
    private MoveState moveState = MoveState.NONE;
    @Unique
    private MoveState lastMoveState = MoveState.NONE;
    @Unique
    private class_243 bonusVelocity = class_243.field_1353;
    @Unique
    private int rollTickCounter = 0;
    @Unique
    private int wallRunCounter = 0;
    @Unique
    private class_243 lastWallDir = class_243.field_1353;
    @Unique
    private boolean isWallLeft = false;
    @Unique
    private int slideCooldown = 0;
    @Unique
    private int diveCooldown = 0;
    @Unique
    private class_2338 lastBlockPos = null;
    @Unique
    private boolean momovement_lastSprintingState = false;
    private static final double BONUS_DECAY_ROLLING = 0.98;
    private static final double BONUS_DECAY_DEFAULT = 0.9;
    private static final int MAX_ROLL_TICKS = 10;
    private int vaultStep = 0;
    private final int totalVaultSteps = 10;
    private final double vaultHeight = 1.25;
    private final double forwardDistance = 1.0;
    private boolean isVaulting = false;

    @Shadow
    public abstract boolean method_7340();

    @Shadow
    protected abstract void method_7318();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public MoveState momovement_getMoveState() {
        return this.moveState;
    }

    @Override
    public void momovement_setMoveState(MoveState moveState) {
        this.moveState = moveState;
    }

    @Unique
    private void updateCurrentMoveState() {
        if (this.lastMoveState != this.moveState) {
            this.lastMoveState = this.moveState;
            class_4050 newPose = null;
            if (this.moveState == MoveState.ROLLING || this.moveState == MoveState.PRONE) {
                this.rollTickCounter = 0;
                newPose = class_4050.field_18079;
            } else if (this.moveState == MoveState.HANGING) {
                newPose = class_4050.field_18076;
            }
            if (newPose != null && this.method_18376() != newPose) {
                this.method_18380(newPose);
            }
            if (this.method_7340()) {
                MoMovement.moveStateUpdater.setMoveState((class_1657)this, this.moveState);
            }
            MoMovement.moveStateUpdater.setAnimationState((class_1657)this, this.moveState);
            this.method_7318();
            this.method_18382();
        }
    }

    @Unique
    private static class_243 momovement_movementInputToVelocity(class_243 movementInput, double speed, float yaw) {
        double d = movementInput.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec3d = (d > 1.0 ? movementInput.method_1029() : movementInput).method_1021(speed);
        double f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        double g = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        return new class_243(vec3d.field_1352 * g - vec3d.field_1350 * f, vec3d.field_1351, vec3d.field_1350 * g + vec3d.field_1352 * f);
    }

    @Unique
    private static class_243 momovement_velocityToMovementInput(class_243 velocity, float yaw) {
        double d = velocity.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        float f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        float g = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        class_243 unrotatedVec = new class_243(velocity.field_1352 * (double)g + velocity.field_1350 * (double)f, velocity.field_1351, -velocity.field_1352 * (double)f + velocity.field_1350 * (double)g);
        return unrotatedVec.method_1027() > 1.0 ? unrotatedVec.method_1029() : unrotatedVec;
    }

    @Unique
    private void momovement_WallRun() {
        class_243 vel = this.method_18798();
        boolean hasWall = this.getWallDirection();
        if (this.isWallRunning()) {
            this.continueWallRun(hasWall, vel);
        } else {
            this.resetWallRun();
            if (this.canStartWallRun(vel)) {
                this.startWallRun();
            }
        }
    }

    private boolean isWallRunning() {
        return this.moveState == MoveState.WALLRUNNING_LEFT || this.moveState == MoveState.WALLRUNNING_RIGHT;
    }

    private void continueWallRun(boolean hasWall, class_243 vel) {
        if (!hasWall || this.method_24828()) {
            this.wallRunCounter = 0;
            this.moveState = MoveState.NONE;
        } else {
            ++this.wallRunCounter;
            this.method_5728(true);
            this.updateWallRunSound();
            class_243 wallVel = this.calculateWallVelocity(vel);
            this.adjustWallRunVelocity(wallVel, vel);
            this.updateVelocityForWallRun(vel);
            this.applyWallRunSpeedCap();
            this.handleWallRunExit(wallVel);
        }
    }

    private void updateWallRunSound() {
        class_2338 wallBlockPos = this.method_24515().method_10059((class_2382)class_2338.method_49638((class_2374)this.lastWallDir));
        if (this.lastBlockPos == null || !this.lastBlockPos.equals((Object)wallBlockPos)) {
            this.lastBlockPos = wallBlockPos;
            this.method_5712(wallBlockPos, this.method_37908().method_8320(wallBlockPos));
        }
    }

    private class_243 calculateWallVelocity(class_243 vel) {
        class_243 flatVel = vel.method_18805(1.0, 0.0, 1.0);
        return this.isWallLeft ? flatVel.method_1029().method_1024(90.0f) : flatVel.method_1029().method_1024(-90.0f);
    }

    private void adjustWallRunVelocity(class_243 wallVel, class_243 flatVel) {
        if (PlayerEntityMixin.momovement_velocityToMovementInput(flatVel, this.method_36454()).method_1026(this.lastWallDir) < 0.0) {
            this.method_45319(wallVel.method_18805(-0.1, 0.0, -0.1));
        }
    }

    private void updateVelocityForWallRun(class_243 vel) {
        this.method_45319(new class_243(0.0, -vel.field_1351 * (1.0 - (double)this.wallRunCounter / (double)MoMovement.getConfig().getWallRunDurationTicks()), 0.0));
        this.bonusVelocity = class_243.field_1353;
    }

    private void applyWallRunSpeedCap() {
        double maxWallRunSpeed = MoMovement.getConfig().getMaxWallRunSpeed();
        if (this.method_18798().method_1033() > maxWallRunSpeed) {
            this.method_18799(this.method_18798().method_1029().method_1021(maxWallRunSpeed));
        }
    }

    private void handleWallRunExit(class_243 wallVel) {
        if (!MoMovement.INPUT.ismoveDownKeyPressed()) {
            this.applyWallRunBoost(wallVel);
            this.moveState = MoveState.NONE;
        }
    }

    private void applyWallRunBoost(class_243 wallVel) {
        double velocityMult = MoMovement.getConfig().getWallRunSpeedBoostMultiplier();
        class_243 boost = wallVel.method_18805(0.3 * velocityMult, 0.0, 0.3 * velocityMult).method_1019(new class_243(0.0, 0.4 * velocityMult, 0.0));
        double maxBoost = 0.5;
        if (boost.method_1033() > maxBoost) {
            boost = boost.method_1029().method_1021(maxBoost);
        }
        this.method_45319(boost);
    }

    private void resetWallRun() {
        this.wallRunCounter = 0;
    }

    private boolean canStartWallRun(class_243 vel) {
        return !this.method_24828() && MoMovement.INPUT.ismoveDownKeyPressed() && this.getWallDirection() && vel.field_1351 <= 0.0;
    }

    private void startWallRun() {
        this.playWallRunSound();
        this.moveState = this.isWallLeft ? MoveState.WALLRUNNING_RIGHT : MoveState.WALLRUNNING_LEFT;
        this.field_7493.method_7583((float)MoMovement.getConfig().getWallRunStaminaCost());
    }

    private void playWallRunSound() {
        this.method_5783(SoundRegistry.MY_SOUND_EVENT, 0.5f, 1.0f);
    }

    @Unique
    private boolean getWallDirection() {
        class_243 flat = this.method_18798().method_18805(1.0, 0.0, 1.0);
        if (flat.method_1027() < 0.01) {
            return false;
        }
        flat = flat.method_1029();
        class_1937 world = this.method_37908();
        class_243 left = flat.method_1024(-90.0f).method_18805(0.5, 0.0, 0.5);
        class_243 right = flat.method_1024(90.0f).method_18805(0.5, 0.0, 0.5);
        if (this.isWallInDirection(left, world)) {
            this.lastWallDir = this.method_24515().method_46558().method_1020(world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 0.2, 0.0), this.method_19538().method_1019(left), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17777().method_46558());
            this.isWallLeft = true;
            return true;
        }
        if (this.isWallInDirection(right, world)) {
            this.lastWallDir = this.method_24515().method_46558().method_1020(world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 0.2, 0.0), this.method_19538().method_1019(right), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17777().method_46558());
            this.isWallLeft = false;
            return true;
        }
        this.lastWallDir = class_243.field_1353;
        return false;
    }

    private boolean isWallInDirection(class_243 direction, class_1937 world) {
        class_3965 upperHit;
        class_3965 lowerHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 0.2, 0.0), this.method_19538().method_1019(direction), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return lowerHit.method_17783() == class_239.class_240.field_1332 && (upperHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 1.5, 0.0), this.method_19538().method_1019(direction), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this))).method_17783() == class_239.class_240.field_1332;
    }

    @Unique
    private boolean momovement_isValidForMovement(boolean canSwim, boolean canElytra) {
        return !(this.method_7325() || !canElytra && this.method_6128() || !canSwim && this.method_5799() || this.method_6101() || this.field_7503.field_7479);
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void momovement_getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        MoveState currentState = this.momovement_getMoveState();
        if (currentState != null && currentState != MoveState.NONE) {
            cir.setReturnValue((Object)currentState.dimensions);
        }
    }

    @Inject(method={"getActiveEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void momovement_getActiveEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        MoveState currentState = this.momovement_getMoveState();
        if (currentState != null && currentState != MoveState.NONE) {
            cir.setReturnValue((Object)Float.valueOf(currentState.dimensions.field_18068 * 0.85f));
        }
    }

    @Unique
    private void startVaulting() {
        if (this.moveState != MoveState.VAULTING) {
            this.moveState = MoveState.VAULTING;
            PlayerEntityMixin.momovement_movementInputToVelocity(new class_243(0.0, 0.0, 1.0), 0.1f, this.method_36454());
            this.method_5728(true);
            this.vaultStep = 0;
            this.isVaulting = true;
            field_38197.info("Vaulting started");
        }
    }

    @Unique
    private void handleVaulting() {
        if (this.isVaulting && this.moveState == MoveState.VAULTING) {
            double yOffset = 0.0;
            double forwardOffset = 0.0;
            if (this.vaultStep < 3) {
                yOffset = 1.25 * (3.0 * (double)this.vaultStep / 10.0);
            } else if (this.vaultStep < 6) {
                yOffset = 1.25;
                forwardOffset = 1.0 * (3.0 * (double)this.vaultStep / 10.0 - 1.0);
            } else {
                yOffset = 1.25 * (3.0 * (double)(10 - this.vaultStep) / 10.0);
                forwardOffset = 1.0;
            }
            class_243 currentPos = this.method_19538();
            double yaw = Math.toRadians(this.method_36454());
            double xOffset = forwardOffset * Math.sin(yaw);
            double zOffset = forwardOffset * Math.cos(yaw);
            class_243 stepVelocity = new class_243(xOffset / 10.0, yOffset / 10.0, zOffset / 10.0);
            this.method_18799(stepVelocity);
            this.method_23327(currentPos.field_1352 + stepVelocity.field_1352, currentPos.field_1351 + yOffset / 10.0, currentPos.field_1350 + stepVelocity.field_1350);
            ++this.vaultStep;
            if (this.vaultStep >= 10) {
                this.moveState = MoveState.NONE;
                this.isVaulting = false;
                field_38197.info("Vaulting handled");
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void momovement_tick(CallbackInfo info) {
        if (!MoMovement.getConfig().enableMoMovement) {
            return;
        }
        if (this.method_7340()) {
            if (this.field_7503.field_7479 || this.method_49694() != null) {
                this.moveState = MoveState.NONE;
                this.updateCurrentMoveState();
                return;
            }
            if (this.moveState == MoveState.ROLLING) {
                this.handleRolling();
            }
            if (this.moveState == MoveState.SLIDING && !MoMovement.INPUT.ismoveDownKeyPressed()) {
                this.moveState = MoveState.NONE;
            }
            if (MoMovement.getConfig().wallRunEnabled) {
                this.momovement_WallRun();
            }
            if (MoMovement.getConfig().ledgeGrabEnabled) {
                this.momovement_LedgeGrab();
            }
            if (MoMovement.getConfig().vaultingEnabled && this.canVault() && MoMovement.INPUT.ismoveUpKeyPressed()) {
                this.startVaulting();
            }
            this.method_45319(this.bonusVelocity);
            this.bonusVelocity = this.bonusVelocity.method_18805(this.getBonusDecay(), 0.0, this.getBonusDecay());
        }
        this.updateCurrentMoveState();
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void momovement_travel(class_243 movementInput, CallbackInfo info) {
        if (!this.method_7340() || !MoMovement.getConfig().enableMoMovement || this.field_7503.field_7479 || this.method_49694() != null) {
            return;
        }
        this.momovement_lastSprintingState = this.method_5624();
        if (this.moveState == MoveState.VAULTING) {
            this.handleVaulting();
            return;
        }
        if (MoMovement.INPUT.ismoveDownKeyPressed() && !MoMovement.INPUT.ismoveDownKeyPressedLastTick()) {
            this.handleSpecialMovements();
        } else if (this.moveState == MoveState.PRONE) {
            this.moveState = MoveState.NONE;
        }
    }

    private void handleRolling() {
        ++this.rollTickCounter;
        if (this.rollTickCounter >= 10) {
            this.rollTickCounter = 0;
            this.moveState = MoMovement.INPUT.ismoveDownKeyPressed() ? MoveState.PRONE : MoveState.NONE;
        }
    }

    private double getBonusDecay() {
        return this.moveState == MoveState.ROLLING ? 0.98 : 0.9;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void momovement_tick_tail(CallbackInfo info) {
        if (!MoMovement.getConfig().enableMoMovement) {
            return;
        }
        if (this.moveState == MoveState.PRONE || this.moveState == MoveState.ROLLING) {
            this.method_18380(class_4050.field_18079);
        }
        if (this.diveCooldown > 0) {
            --this.diveCooldown;
        }
        if (this.slideCooldown > 0) {
            --this.slideCooldown;
        }
    }

    @Unique
    private boolean canVault() {
        class_2338 playerPos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)this.method_23321()));
        class_1937 world = this.method_5770();
        class_2338 blockInFrontPos = playerPos.method_10093(this.method_5735());
        class_2338 blockAboveInFrontPos = blockInFrontPos.method_10084();
        class_2680 blockInFront = world.method_8320(blockInFrontPos);
        class_2680 blockAboveInFront = world.method_8320(blockAboveInFrontPos);
        boolean vaultable = blockInFront.method_26212((class_1922)world, blockInFrontPos) && !blockAboveInFront.method_26212((class_1922)world, blockAboveInFrontPos);
        field_38197.info("Vaultable: " + vaultable);
        return vaultable;
    }

    private void handleSpecialMovements() {
        MoMovementConfig conf = MoMovement.getConfig();
        boolean canDiveRoll = this.canPerformDiveRoll(conf);
        boolean canSlide = this.canPerformSlide(conf);
        if (canDiveRoll) {
            this.performDiveRoll(conf);
        } else if (canSlide) {
            this.performSlide(conf);
        }
    }

    private boolean canPerformDiveRoll(MoMovementConfig conf) {
        return this.diveCooldown == 0 && conf.diveRollEnabled && !this.method_24828() && this.method_18798().method_18805(1.0, 0.0, 1.0).method_1027() > 0.05 && this.momovement_isValidForMovement(conf.diveRollWhenSwimming, conf.diveRollWhenFlying);
    }

    private boolean canPerformSlide(MoMovementConfig conf) {
        return this.slideCooldown == 0 && conf.slideEnabled && this.momovement_lastSprintingState && this.momovement_isValidForMovement(false, false);
    }

    private void performDiveRoll(MoMovementConfig conf) {
        this.diveCooldown = conf.getDiveRollCoolDown() / 2;
        this.field_7493.method_7583((float)conf.getDiveRollStaminaCost());
        this.moveState = MoveState.ROLLING;
        this.bonusVelocity = PlayerEntityMixin.momovement_movementInputToVelocity(class_243.field_1353, (double)0.15f * conf.getDiveRollSpeedBoostMultiplier(), this.method_36454());
        this.method_5728(true);
        this.playFeedback();
    }

    private void performSlide(MoMovementConfig conf) {
        this.slideCooldown = conf.getSlideCoolDown() / 2;
        this.field_7493.method_7583((float)conf.getSlideStaminaCost());
        this.moveState = MoveState.SLIDING;
        this.bonusVelocity = PlayerEntityMixin.momovement_movementInputToVelocity(new class_243(0.0, 0.0, 1.0), 0.25 * conf.getSlideSpeedBoostMultiplier(), this.method_36454());
        this.method_5728(true);
        this.playFeedback();
    }

    private void playFeedback() {
    }

    @Inject(method={"adjustMovementForSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void momovement_adjustMovementForSneaking(class_243 movement, class_1313 type, CallbackInfoReturnable<class_243> cir) {
        if (this.method_7340() && (this.moveState == MoveState.ROLLING || this.moveState == MoveState.SLIDING)) {
            cir.setReturnValue((Object)movement);
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    private void momovement_jump(CallbackInfo info) {
        if (this.method_7340()) {
            this.method_5728(this.momovement_lastSprintingState);
            if (this.moveState == MoveState.SLIDING || this.moveState == MoveState.PRONE) {
                this.moveState = MoveState.NONE;
            }
            if (this.moveState == MoveState.ROLLING) {
                this.moveState = MoveState.PRONE;
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void momovement_damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_48792().comp_1246() == class_8112.field_42362 && this.moveState == MoveState.ROLLING) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Unique
    private boolean canHangUnderBlock() {
        class_2338 blockAbovePos;
        class_2338 playerPos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)this.method_23321()));
        class_1937 world = this.method_5770();
        class_2680 blockAbove = world.method_8320(blockAbovePos = playerPos.method_10084());
        return blockAbove.method_26212((class_1922)world, blockAbovePos) || blockAbove.method_26164(class_3481.field_22414) || this.isFence(blockAbove);
    }

    private boolean isFence(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof class_2354 || block instanceof class_2349;
    }

    @Unique
    private void handleClimbing() {
        if (this.canHangUnderBlock()) {
            if (this.moveState != MoveState.HANGING) {
                this.moveState = MoveState.HANGING;
                this.method_18380(class_4050.field_18076);
            }
            this.adjustHangingVelocity();
            if (MoMovement.INPUT.ismoveUpKeyPressed()) {
                this.method_18799(this.method_18798().method_1031(0.0, 2.0, 0.0));
            } else if (MoMovement.INPUT.ismoveDownKeyPressed()) {
                this.method_18799(this.method_18798().method_1031(0.0, -1.0, 0.0));
            }
        } else if (this.moveState == MoveState.HANGING) {
            this.moveState = MoveState.NONE;
        }
    }

    private void adjustHangingVelocity() {
        this.method_18799(this.method_18798().method_18805(0.5, 3.0, 0.5));
    }

    @Unique
    private void momovement_LedgeGrab() {
        if (this.moveState == MoveState.LEDGE_GRABBING) {
            this.handleLedgeHanging();
        } else if (this.canInitiateLedgeGrab()) {
            this.initiateLedgeGrab();
        }
    }

    private void handleLedgeHanging() {
        if (MoMovement.INPUT.ismoveUpKeyPressed()) {
            this.climbLedge();
        } else if (!this.isLedgeGrabbingConditionsMet()) {
            this.moveState = MoveState.NONE;
            this.method_18799(new class_243(this.method_18798().field_1352, 0.5, this.method_18798().field_1350));
        } else {
            this.method_18799(class_243.field_1353);
            this.method_23327(this.method_23317(), Math.floor(this.method_23318()), this.method_23321());
        }
    }

    private void climbLedge() {
        this.moveState = MoveState.NONE;
    }

    private boolean canInitiateLedgeGrab() {
        return !this.method_24828() && this.method_18798().field_1351 < 0.0 && this.canGrabLedge() && MoMovement.INPUT.ismoveDownKeyPressed();
    }

    private void initiateLedgeGrab() {
        this.moveState = MoveState.LEDGE_GRABBING;
    }

    private boolean isLedgeGrabbingConditionsMet() {
        return !this.method_24828() && this.canGrabLedge();
    }

    @Unique
    private boolean canGrabLedge() {
        class_2338 playerPos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)this.method_23321()));
        class_1937 world = this.method_5770();
        class_2338 blockInFrontPos = playerPos.method_10093(this.method_5735());
        class_2338 blockAboveInFrontPos = blockInFrontPos.method_10084();
        class_2680 blockInFront = world.method_8320(blockInFrontPos);
        class_2680 blockAboveInFront = world.method_8320(blockAboveInFrontPos);
        return blockInFront.method_26212((class_1922)world, blockInFrontPos) && !blockAboveInFront.method_26212((class_1922)world, blockAboveInFrontPos);
    }
}

