/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.CommonClass;
import com.leclowndu93150.particular.NeoForgeParticles;
import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.particles.CascadeParticle;
import com.leclowndu93150.particular.particles.CaveDustParticle;
import com.leclowndu93150.particular.particles.EnderBubbleParticle;
import com.leclowndu93150.particular.particles.FireflyParticle;
import com.leclowndu93150.particular.particles.WaterRippleParticle;
import com.leclowndu93150.particular.particles.WaterfallSprayParticle;
import com.leclowndu93150.particular.particles.leaves.ConiferLeafParticle;
import com.leclowndu93150.particular.particles.leaves.LeafParticle;
import com.leclowndu93150.particular.particles.leaves.SpinningLeafParticle;
import com.leclowndu93150.particular.particles.splashes.WaterSplashEmitterParticle;
import com.leclowndu93150.particular.particles.splashes.WaterSplashFoamParticle;
import com.leclowndu93150.particular.particles.splashes.WaterSplashParticle;
import com.leclowndu93150.particular.particles.splashes.WaterSplashRingParticle;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="particular", value={Dist.CLIENT})
public class NeoForgeClientEvents {
    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)NeoForgeParticles.OAK_LEAF.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.BIRCH_LEAF.get(), SpinningLeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.SPRUCE_LEAF.get(), ConiferLeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.JUNGLE_LEAF.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.ACACIA_LEAF.get(), SpinningLeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.DARK_OAK_LEAF.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.AZALEA_LEAF.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.MANGROVE_LEAF.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATER_RIPPLE.get(), WaterRippleParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.ENDER_BUBBLE.get(), EnderBubbleParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.ENDER_BUBBLE_POP.get(), BubblePopParticle.Provider::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.CAVE_DUST.get(), CaveDustParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.FIREFLY.get(), FireflyParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATERFALL_SPRAY.get(), WaterfallSprayParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.CASCADE.get(), CascadeParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATER_SPLASH_EMITTER.get(), WaterSplashEmitterParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATER_SPLASH.get(), WaterSplashParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATER_SPLASH_FOAM.get(), WaterSplashFoamParticle.Factory::new);
        event.registerSpriteSet((ParticleType)NeoForgeParticles.WATER_SPLASH_RING.get(), WaterSplashRingParticle.Factory::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(CommonClass::clientSetup);
    }

    @EventBusSubscriber(modid="particular", value={Dist.CLIENT})
    public static class ForgeEvents {
        private static int cascadeCleanupTicks = 0;

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            ClientLevel world = Minecraft.getInstance().level;
            CommonClass.onClientTick((Level)world);
            if (world != null && ++cascadeCleanupTicks >= 100) {
                cascadeCleanupTicks = 0;
                CommonClass.cleanupInvalidCascades((Level)world);
            }
        }

        @SubscribeEvent
        public static void onRenderHUD(RenderGuiEvent.Post event) {
            if (FMLLoader.getCurrent().isProduction()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null || mc.level == null) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Font font = mc.font;
            String cascadeText = "Cascades: " + CommonClass.cascades.size();
            int textWidth = font.width(cascadeText);
            int x = 10;
            int y = 10;
            Objects.requireNonNull(font);
            guiGraphics.fill(x - 2, y - 2, x + textWidth + 2, y + 9 + 2, Integer.MIN_VALUE);
            guiGraphics.drawString(font, cascadeText, x, y, 0xFFFFFF);
        }

        @SubscribeEvent
        public static void onChunkLoad(ChunkEvent.Load event) {
            Level world = (Level)event.getLevel();
            CommonClass.onChunkLoad(world);
        }

        @SubscribeEvent
        public static void onChunkUnload(ChunkEvent.Unload event) {
            Level world = (Level)event.getLevel();
            if (!ParticularConfig.cascades() || !world.isClientSide()) {
                return;
            }
            ChunkPos chunkPos = ((LevelChunk)event.getChunk()).getPos();
            int minX = chunkPos.getMinBlockX();
            int maxX = chunkPos.getMaxBlockX();
            int minZ = chunkPos.getMinBlockZ();
            int maxZ = chunkPos.getMaxBlockZ();
            CommonClass.onChunkUnload(world, minX, maxX, minZ, maxZ);
        }

        @SubscribeEvent
        public static void onLevelUnload(LevelEvent.Unload event) {
            CommonClass.onLevelUnload((Level)event.getLevel());
        }
    }
}

