/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles;

import com.leclowndu93150.particular.ParticularConfig;
import com.leclowndu93150.particular.utils.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class CaveDustParticle
extends BaseAshSmokeParticle {
    protected CaveDustParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float scaleMultiplier, SpriteSet spriteProvider) {
        super(world, x, y, z, 0.0f, 0.0f, 0.0f, velocityX, velocityY, velocityZ, scaleMultiplier, spriteProvider, 0.0f, ((Integer)ParticularConfig.COMMON.caveDustBaseMaxAge.get()).intValue(), 0.0f, true);
        Color color = Color.ofArgb((Integer)ParticularConfig.COMMON.caveDustColor.get());
        this.rCol = color.red();
        this.gCol = color.green();
        this.bCol = color.blue();
        this.gravity = (float)((double)(this.random.nextFloat() - 0.5f) * (Double)ParticularConfig.COMMON.caveDustMaxAcceleration.get());
    }

    public void tick() {
        int fadeDuration;
        super.tick();
        if (this.random.nextInt(((Integer)ParticularConfig.COMMON.caveDustAccelChangeChance.get()).intValue()) == 0) {
            this.gravity = (this.random.nextFloat() - 0.5f) * ((Double)ParticularConfig.COMMON.caveDustMaxAcceleration.get()).floatValue();
        }
        if (this.age <= (fadeDuration = ((Integer)ParticularConfig.COMMON.caveDustFadeDuration.get()).intValue())) {
            this.alpha = (float)this.age / (float)fadeDuration;
        } else if (this.age > this.lifetime - fadeDuration) {
            this.alpha = (float)(this.lifetime - this.age) / (float)fadeDuration;
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double x, double y, double z, double velX, double velY, double velZ, RandomSource random) {
            return new CaveDustParticle(clientWorld, x, y, z, 0.0, 0.0, 0.0, 1.0f, this.provider);
        }
    }
}

