/*
 * Decompiled with CFR 0.152.
 */
package net.minttea.musicdiskblock.block.entity;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minttea.musicdiskblock.block.entity.ModBlockEntities;
import net.minttea.musicdiskblock.config.MusicDiskBlockCommonConfigs;
import net.minttea.musicdiskblock.item.ModItems;
import net.minttea.musicdiskblock.recipe.MusicDiskCrafterRecipe;
import net.minttea.musicdiskblock.screen.MusicDiskCrafterMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicDiskBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            MusicDiskBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MusicDiskBlockEntity.this.progress;
                case 1 -> MusicDiskBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MusicDiskBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MusicDiskBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 200;

    public MusicDiskBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MUSIC_DISK_CRAFTER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new MusicDiskCrafterMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MusicDiskBlockEntity entity) {
        if (level.m_5776_()) {
            return;
        }
        if (MusicDiskBlockEntity.hasRecipe(entity) && entity.itemHandler.getStackInSlot(1).m_41613_() >= (Integer)MusicDiskBlockCommonConfigs.CONSUME_AMOUNT.get()) {
            ++entity.progress;
            MusicDiskBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (entity.progress >= entity.maxProgress) {
                MusicDiskBlockEntity.craftItem(entity);
            }
        } else {
            entity.resetProgress();
            MusicDiskBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(MusicDiskBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)MusicDiskCrafterRecipe.Type.INSTANCE, (Container)inventory, level);
        if (MusicDiskBlockEntity.hasRecipe(entity) && entity.itemHandler.getStackInSlot(1).m_41613_() >= (Integer)MusicDiskBlockCommonConfigs.CONSUME_AMOUNT.get()) {
            entity.itemHandler.extractItem(1, ((Integer)MusicDiskBlockCommonConfigs.CONSUME_AMOUNT.get()).intValue(), false);
            int damage = entity.itemHandler.getStackInSlot(0).m_41773_();
            if (damage + 1 < entity.itemHandler.getStackInSlot(0).m_41776_()) {
                entity.itemHandler.getStackInSlot(0).m_41721_(damage + 1);
            } else {
                entity.itemHandler.extractItem(0, 1, false);
            }
            Random probability = new Random();
            if (probability.nextInt(0, 100) <= (Integer)MusicDiskBlockCommonConfigs.CRAFT_CHANCE.get()) {
                entity.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)MusicDiskBlockEntity.getRandomOutput(recipe).m_41720_(), entity.itemHandler.getStackInSlot(2).m_41613_() + 1));
                entity.resetProgress();
            } else {
                entity.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ModItems.DISC_FRAGMENT.get(), probability.nextInt(3, (Integer)MusicDiskBlockCommonConfigs.CONSUME_AMOUNT.get() - 2) + entity.itemHandler.getStackInSlot(1).m_41613_()));
                entity.resetProgress();
            }
        }
    }

    private static boolean hasRecipe(MusicDiskBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)MusicDiskCrafterRecipe.Type.INSTANCE, (Container)inventory, level);
        boolean hasNeedleInSlot = entity.itemHandler.getStackInSlot(0).m_41720_() == ModItems.NEEDLE.get() || entity.itemHandler.getStackInSlot(0).m_41720_() == ModItems.STEEL_NEEDLE.get();
        return recipe.isPresent() && MusicDiskBlockEntity.canInsertAmountInOutputSlot(inventory) && hasNeedleInSlot && MusicDiskBlockEntity.canInsertItemIntoOutputSlot(inventory, ((MusicDiskCrafterRecipe)recipe.get()).m_8043_());
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack itemStack) {
        return inventory.m_8020_(2).m_41720_() == itemStack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountInOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }

    private static ItemStack getRandomOutput(Optional<MusicDiskCrafterRecipe> recipe) {
        Random ran = new Random();
        String[] items = ((String)MusicDiskBlockCommonConfigs.POSSIBLE_ITEMS.get()).split(";");
        for (int i = 0; i < items.length; ++i) {
            items[i] = items[i].strip();
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(items[ran.nextInt(items.length)]));
        return item.m_7968_();
    }
}

