/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.key;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.KeyMapping;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.cyclops.cyclopscore.client.key.IKeyHandler;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;

public class KeyRegistry
implements IKeyRegistry {
    private final Multimap<KeyMapping, IKeyHandler> keyHandlerMap = HashMultimap.create();

    public static KeyMapping newKeyMapping(ModBaseNeoForge mod, String name, int defaultKey) {
        String id = IModHelpers.get().getL10NHelpers().localize("key." + mod.getModId() + "." + name, new Object[0]);
        String category = IModHelpers.get().getL10NHelpers().localize("key.categories." + mod.getModId(), new Object[0]);
        return new KeyMapping(id, defaultKey, category);
    }

    @Override
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerKeyInput(ClientTickEvent.Post event) {
        for (KeyMapping kb : this.keyHandlerMap.keySet()) {
            while (kb.consumeClick()) {
                this.fireKeyPressed(kb);
            }
        }
    }

    private void fireKeyPressed(KeyMapping kb) {
        for (IKeyHandler h : this.keyHandlerMap.get((Object)kb)) {
            h.onKeyPressed(kb);
        }
    }

    @Override
    public void addKeyHandler(KeyMapping kb, IKeyHandler handler) {
        this.keyHandlerMap.put((Object)kb, (Object)handler);
    }
}

