/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.CraftingRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendixClient;

public class CraftingRecipeAppendixClient
extends RecipeAppendixClient<CraftingRecipeAppendix> {
    protected CraftingRecipeAppendixClient(CraftingRecipeAppendix sectionAppendix) {
        super(sectionAppendix);
    }

    public void bakeElement(InfoSection infoSection) {
        Map<AdvancedButtonEnum, AdvancedButton> renderItemHolders = ((CraftingRecipeAppendix)this.getSectionAppendix()).getRenderItemHolders();
        for (int i = 0; i < 9; ++i) {
            renderItemHolders.put(CraftingRecipeAppendix.INPUT[i], new RecipeAppendixClient.ItemButton(((CraftingRecipeAppendix)this.getSectionAppendix()).getInfoBook()));
        }
        renderItemHolders.put(CraftingRecipeAppendix.RESULT, new RecipeAppendixClient.ItemButton(((CraftingRecipeAppendix)this.getSectionAppendix()).getInfoBook()));
    }

    @Override
    protected void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int j;
        int i;
        gui.drawArrowRight(guiGraphics, x + 63 - 3, y + 5 + 16 + 2);
        RecipeDisplayEntry recipeDisplay = ((CraftingRecipeAppendix)this.getSectionAppendix()).getRecipeDisplay();
        if (recipeDisplay == null) {
            return;
        }
        int tick = this.getTick(gui);
        ItemStack[] grid = new ItemStack[9];
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
        ItemStack result = this.prepareItemStacks(recipeDisplay.display().result().resolveForStacks(contextMap), tick);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                grid[i + j * 3] = this.getItemStacks(recipeDisplay, i + j * 3, contextMap, tick);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.renderItem(gui, guiGraphics, x + 21 * i, y + 21 * j, grid[i + j * 3], mx, my, CraftingRecipeAppendix.INPUT[i + j * 3]);
            }
        }
        this.renderItem(gui, guiGraphics, x + 84, y + 21, result, mx, my, CraftingRecipeAppendix.RESULT);
        this.renderItem(gui, guiGraphics, x + 63, y + 5 + 16, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), mx, my, false, null);
    }

    private static NonNullList<ItemStack> formatShapedGrid(List<ItemStack> itemStacksRaw, int width, int height) {
        int rawIndex = 0;
        NonNullList itemStacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                itemStacks.set(y * 3 + x, (Object)itemStacksRaw.get(rawIndex++));
                if (rawIndex >= itemStacksRaw.size()) break;
            }
            if (rawIndex >= itemStacksRaw.size()) break;
        }
        return itemStacks;
    }

    protected ItemStack getItemStacks(RecipeDisplayEntry recipeDisplay, int index, ContextMap contextMap, int tick) {
        Object ingredients;
        RecipeDisplay recipeDisplay2 = recipeDisplay.display();
        if (recipeDisplay2 instanceof ShapedCraftingRecipeDisplay) {
            ShapedCraftingRecipeDisplay shapedDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay2;
            ingredients = CraftingRecipeAppendixClient.formatShapedGrid(shapedDisplay.ingredients().stream().map(display -> this.prepareItemStacks(display.resolveForStacks(contextMap), tick)).toList(), shapedDisplay.width(), shapedDisplay.height());
        } else {
            recipeDisplay2 = recipeDisplay.display();
            if (recipeDisplay2 instanceof ShapelessCraftingRecipeDisplay) {
                ShapelessCraftingRecipeDisplay shapelessDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                ingredients = shapelessDisplay.ingredients().stream().map(display -> this.prepareItemStacks(display.resolveForStacks(contextMap), tick)).toList();
            } else {
                throw new IllegalArgumentException("Unsupported recipe display class: " + String.valueOf(recipeDisplay.display()));
            }
        }
        if (ingredients.size() <= index) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)ingredients.get(index);
    }
}

