/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.infobook.pageelement.IRewardClient;
import org.cyclops.cyclopscore.infobook.pageelement.RewardItemClient;

public class RewardItem
implements IReward {
    protected static final int SLOT_SIZE = 16;
    private final ItemStack itemStack;

    public RewardItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public boolean canObtain(Player player) {
        return true;
    }

    @Override
    public void obtain(Player player) {
        if (!player.getInventory().add(this.itemStack.copy())) {
            IModHelpers.get().getItemStackHelpers().spawnItemStack(player.level(), player.blockPosition(), this.itemStack.copy());
        }
    }

    @Override
    public int getWidth() {
        return 20;
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public IRewardClient constructRewardClient() {
        return new RewardItemClient(this);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

