/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;

public class ListValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Font fontRenderer = context.getFont();
        float maxWidth = 0.0f;
        LinkedList lines = Lists.newLinkedList();
        Object listType = ((ValueTypeList.ValueList)value).getRawValue().getValueType();
        for (IValue element : ((ValueTypeList.ValueList)value).getRawValue()) {
            if (lines.size() >= 20) {
                lines.add(Pair.of((Object)"...", (Object)listType.getDisplayColor()));
                break;
            }
            IValueType elementType = element.getType();
            String string = " - " + elementType.toCompactString(element).getString();
            float width = fontRenderer.width(string) - 1;
            lines.add(Pair.of((Object)string, (Object)elementType.getDisplayColor()));
            maxWidth = Math.max(maxWidth, width);
        }
        Objects.requireNonNull(fontRenderer);
        float singleHeight = 9.0f;
        float totalHeight = singleHeight * (float)lines.size();
        matrixStack.pushPose();
        float scaleX = 12.5f / (maxWidth * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = maxWidth * scale;
        float newHeight = totalHeight * scale;
        matrixStack.translate((12.5f - newWidth) / 2.0f, (12.5f - newHeight) / 2.0f, 0.0f);
        matrixStack.scale(scale, scale, 1.0f);
        int offset = 0;
        for (Pair line : lines) {
            int color = IModHelpers.get().getBaseHelpers().addAlphaToColor(((Integer)line.getRight()).intValue(), alpha);
            context.getFont().drawInBatch((String)line.getLeft(), 0.0f, (float)offset, color, false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            offset = (int)((float)offset + singleHeight);
        }
        matrixStack.popPose();
    }
}

