/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyNbtKeys
extends ValueTypeListProxyBase<ValueTypeString, ValueTypeString.ValueString> {
    private final Optional<Tag> tag;

    public ValueTypeListProxyNbtKeys(Optional<Tag> tag) {
        super(ValueTypeListProxyFactories.NBT_KEYS.getName(), ValueTypes.STRING);
        this.tag = tag;
    }

    @Override
    public int getLength() throws EvaluationException {
        return this.tag.map(t -> t instanceof CompoundTag ? ((CompoundTag)t).keySet().size() : 0).orElse(0);
    }

    @Override
    public ValueTypeString.ValueString get(int index) throws EvaluationException {
        if (index < this.getLength()) {
            return ValueTypeString.ValueString.of((String)Iterables.get((Iterable)((CompoundTag)this.tag.get()).keySet(), (int)index));
        }
        return null;
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<ValueTypeString, ValueTypeString.ValueString, ValueTypeListProxyNbtKeys> {
        @Override
        public ResourceLocation getName() {
            return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"nbt.keys");
        }

        @Override
        protected void serializeNbt(ValueOutput valueOutput, ValueTypeListProxyNbtKeys value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            value.tag.ifPresent(inbt -> valueOutput.store("tag", ExtraCodecs.NBT, inbt));
        }

        @Override
        protected ValueTypeListProxyNbtKeys deserializeNbt(ValueInput valueInput) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            return new ValueTypeListProxyNbtKeys(valueInput.read("tag", ExtraCodecs.NBT));
        }
    }
}

