/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;

public final class Helpers {
    public static final Predicate<Entity> SELECTOR_IS_PLAYER = entity -> entity instanceof Player;
    public static final TagParser<Tag> TAG_PARSER = TagParser.create((DynamicOps)NbtOps.INSTANCE);
    private static final List<IInterfaceRetriever> INTERFACE_RETRIEVERS = Lists.newArrayList();

    public static FluidStack getFluidStack(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (fluidStack.isEmpty() && itemStack.getItem() instanceof BlockItem && ((BlockItem)itemStack.getItem()).getBlock() instanceof LiquidBlock) {
            fluidStack = new FluidStack((Fluid)((LiquidBlock)((BlockItem)itemStack.getItem()).getBlock()).fluid, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume());
        }
        return fluidStack;
    }

    public static int getFluidStackCapacity(ItemStack itemStack) {
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (fluidHandler != null && fluidHandler.getTanks() > 0) {
            return fluidHandler.getTankCapacity(0);
        }
        return 0;
    }

    public static Stream<ItemStack> getTagValues(String name) throws ResourceLocationException {
        Optional tag = BuiltInRegistries.ITEM.get(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)name)));
        return tag.stream().flatMap(named -> named.stream().map(ItemStack::new));
    }

    public static Stream<BlockState> getBlockTagValues(String name) throws ResourceLocationException {
        Optional tag = BuiltInRegistries.BLOCK.get(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)name)));
        return tag.stream().flatMap(named -> named.stream().map(block -> ((Block)block.value()).defaultBlockState()));
    }

    public static Stream<FluidStack> getFluidTagValues(String name) throws ResourceLocationException {
        Optional tag = BuiltInRegistries.FLUID.get(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.parse((String)name)));
        return tag.stream().flatMap(named -> named.stream().map(fluid -> new FluidStack(fluid, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume())));
    }

    public static <T> List<T> joinList(List<T> list, T newElement) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(list);
        if (newElement != null) {
            builder.add(newElement);
        }
        return builder.build();
    }

    public static String createPatternOfLength(int length) {
        StringBuilder pattern = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                first = false;
            } else {
                pattern.append(",");
            }
            pattern.append("%s");
        }
        return pattern.toString();
    }

    private static <C> Optional<C> getInterface(BlockGetter world, BlockPos pos, Class<C> clazz) {
        for (IInterfaceRetriever interfaceRetriever : INTERFACE_RETRIEVERS) {
            Optional<C> optionalInstance = interfaceRetriever.getInterface(world, pos, clazz);
            if (!optionalInstance.isPresent()) continue;
            return optionalInstance;
        }
        return Optional.empty();
    }

    public static <C> Optional<C> getInterface(DimPos dimPos, Class<C> clazz, boolean forceLoad) {
        Level world = dimPos.getLevel(forceLoad);
        return world != null ? Helpers.getInterface((BlockGetter)world, dimPos.getBlockPos(), clazz) : Optional.empty();
    }

    public static Component getLocalizedEnergyLevel(int stored, int capacity) {
        return Component.literal((String)String.format(Locale.ROOT, "%,d", stored)).append(" / ").append(String.format(Locale.ROOT, "%,d", capacity)).append(" ").append((Component)Component.translatable((String)"general.integrateddynamics.energy_unit"));
    }

    public static double calculateTps(long[] times) {
        double worldTickTime = (double)Helpers.mean(times) * 1.0E-6;
        double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
        return worldTPS;
    }

    public static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static void addInterfaceRetriever(IInterfaceRetriever interfaceRetriever) {
        INTERFACE_RETRIEVERS.add(interfaceRetriever);
    }

    public static String capitalizeString(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return "";
        }
        return Character.toTitleCase(value.charAt(0)) + value.substring(1);
    }

    public static void returnItemToPlayer(Player player, ItemStack itemStack) {
        if (!(!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected())) {
            player.getInventory().placeItemBackInInventory(itemStack);
        } else {
            player.drop(itemStack, false);
        }
    }

    public static <T extends Exception, R> R sneakyThrow(Exception t) throws T {
        throw t;
    }

    static {
        Helpers.addInterfaceRetriever(new IInterfaceRetriever(){

            @Override
            public <C> Optional<C> getInterface(BlockGetter world, BlockPos pos, Class<C> clazz) {
                return IModHelpers.get().getBlockEntityHelpers().get(world, pos, clazz);
            }
        });
    }

    public static interface IInterfaceRetriever {
        public <C> Optional<C> getInterface(BlockGetter var1, BlockPos var2, Class<C> var3);
    }
}

