/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.network.PacketCodecs;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPathElement;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.PartTypeRegistry;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    @Deprecated
    public static Optional<IPartContainer> getPartContainer(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.PartContainer.BLOCK);
    }

    public static Optional<IPartContainer> getPartContainer(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return Optional.ofNullable((IPartContainer)world.getCapability(Capabilities.PartContainer.BLOCK, pos, blockState, null, (Object)side));
    }

    @Deprecated
    public static Optional<IPartContainer> getPartContainer(DimPos dimPos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(dimPos, (Object)side, Capabilities.PartContainer.BLOCK);
    }

    public static Optional<IPartContainer> getPartContainer(DimPos dimPos, @Nullable Direction side, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity) {
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((IPartContainer)level.getCapability(Capabilities.PartContainer.BLOCK, dimPos.getBlockPos(), blockState, blockEntity, (Object)side));
    }

    public static IPartContainer getPartContainerChecked(Level world, BlockPos pos, @Nullable Direction side) {
        return PartHelpers.getPartContainer((ILevelExtension)world, pos, side).orElseThrow(() -> new PartStateException(DimPos.of((Level)world, (BlockPos)pos), side));
    }

    public static IPartContainer getPartContainerChecked(DimPos dimPos, @Nullable Direction side) {
        return PartHelpers.getPartContainer(dimPos, side).orElseThrow(() -> new PartStateException(dimPos, side));
    }

    public static IPartContainer getPartContainerChecked(DimPos dimPos, @Nullable Direction side, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity) {
        return PartHelpers.getPartContainer(dimPos, side, blockState, blockEntity).orElseThrow(() -> new PartStateException(dimPos, side));
    }

    public static IPartContainer getPartContainerChecked(PartPos pos) {
        return PartHelpers.getPartContainerChecked(pos.getPos(), pos.getSide());
    }

    public static IPartType validatePartType(INetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void serializePartType(ValueOutput valueOutput, Direction side, IPartType partType) {
        valueOutput.putString("__partType", partType.getUniqueName().toString());
        valueOutput.putString("__side", side.getSerializedName());
    }

    public static boolean serializePart(ValueOutput valueOutput, BlockPos pos, Pair<Direction, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.serializePartType(valueOutput, (Direction)partData.getKey(), part);
        try {
            part.serializeState(valueOutput, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getUniqueName(), pos));
            return false;
        }
    }

    public static void serializeParts(ValueOutput valueOutput, BlockPos pos, Map<Direction, PartStateHolder<?, ?>> partData) {
        ValueOutput.ValueOutputList partList = valueOutput.childrenList("parts");
        for (Map.Entry<Direction, PartStateHolder<?, ?>> entry : partData.entrySet()) {
            if (PartHelpers.serializePart(partList.addChild(), pos, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.discardLast();
        }
    }

    public static Pair<Direction, IPartType> deserializePartType(ValueInput valueInput, @Nullable INetwork network, BlockPos pos) {
        String partTypeName = (String)valueInput.getString("__partType").orElseThrow();
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(ResourceLocation.parse((String)partTypeName)));
        if (partType != null) {
            Direction side = Direction.byName((String)((String)valueInput.getString("__side").orElseThrow()));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getUniqueName(), pos));
        } else {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<Direction, ? extends PartStateHolder<?, ?>> deserializePart(ValueInput valueInput, @Nullable INetwork network, BlockPos pos) {
        Pair<Direction, IPartType> partData = PartHelpers.deserializePartType(valueInput, network, pos);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).deserializeState(valueInput);
            return Pair.of((Object)((Direction)partData.getKey()), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void deserializeParts(ValueInput valueInput, @Nullable INetwork network, BlockPos pos, Map<Direction, PartStateHolder<?, ?>> partData, Level world) {
        ImmutableMap oldPartData = ImmutableMap.copyOf(partData);
        partData.clear();
        for (ValueInput partTag : (ValueInput.ValueInputList)valueInput.childrenList("parts").orElseThrow()) {
            Pair<Direction, ? extends PartStateHolder<?, ?>> part = PartHelpers.deserializePart(partTag, network, pos);
            if (part == null) continue;
            partData.put((Direction)part.getKey(), (PartStateHolder)part.getValue());
        }
        if (world != null && world.isClientSide()) {
            boolean triggerBlockRenderUpdate = false;
            for (Direction side : Direction.values()) {
                Object newPartState;
                PartStateHolder oldData = (PartStateHolder)oldPartData.get(side);
                PartStateHolder<?, ?> newData = partData.get(side);
                if (oldData == null && newData == null) continue;
                IPartType oldPartType = oldData != null ? oldData.getPart() : null;
                IPartType<?, ?> newPartType = newData != null ? newData.getPart() : null;
                Object oldPartState = oldData != null ? (Object)oldData.getState() : null;
                Object s = newPartState = newData != null ? (Object)newData.getState() : null;
                if (oldPartType == newPartType && !oldPartType.shouldTriggerBlockRenderUpdate(oldPartState, newPartState)) continue;
                triggerBlockRenderUpdate = true;
                break;
            }
            if (triggerBlockRenderUpdate) {
                IModHelpers.get().getBlockHelpers().markForUpdate(world, pos);
            }
        }
    }

    public static boolean removePart(Level world, BlockPos pos, Direction side, @Nullable Player player, boolean destroyIfEmpty, boolean dropMainElement, boolean saveState) {
        boolean removeCompletely;
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable((ILevelExtension)world, pos, side).orElse(null);
        partContainer.removePart(side, player, dropMainElement, saveState);
        boolean bl = removeCompletely = destroyIfEmpty && (cableFakeable == null || !cableFakeable.isRealCable()) && !partContainer.hasParts();
        if (removeCompletely) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            world.updateNeighborsAt(pos, world.getBlockState(pos).getBlock());
            if (CableHelpers.getCable((ILevelExtension)world, pos.relative(side), side.getOpposite()).isPresent()) {
                CableHelpers.updateConnections((ILevelExtension)world, pos, side);
                CableHelpers.updateConnections((ILevelExtension)world, pos.relative(side), side.getOpposite());
                NetworkHelpers.initNetwork((ILevelExtension)world, pos, side);
            }
        }
        return !removeCompletely;
    }

    public static boolean addPart(Level level, BlockPos pos, Direction side, IPartType partType, ItemStack itemStack) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(level, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!level.isClientSide()) {
                partContainer.setPart(side, partType, partType.getState(ValueDeseralizationContext.of(level), new PartPathElement(pos), itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean addPart(Level world, BlockPos pos, Direction side, IPartType partType, IPartState partState) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.isClientSide()) {
                partContainer.setPart(side, partType, partState);
            }
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable INetwork network, Level world, BlockPos pos, Direction side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
            INetworkElement networkElement = part.createNetworkElement(partContainer, DimPos.of((Level)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.defaultBlockState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canInteractWith(PartTarget target, Player player, IPartContainer expectedPartContainer) {
        IPartContainer partContainer = PartHelpers.getPartContainer(target.getCenter().getPos(), target.getCenter().getSide()).orElse(null);
        return partContainer == expectedPartContainer;
    }

    @Nullable
    public static PartStateHolder<?, ?> getPart(PartPos partPos) {
        Direction side = partPos.getSide();
        IPartContainer partContainer = PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide()).orElse(null);
        if (partContainer != null && partContainer.hasPart(side)) {
            return PartStateHolder.of(partContainer.getPart(side), partContainer.getPartState(side));
        }
        return null;
    }

    public static InteractionResult openContainerPart(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProvider(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiData((RegistryFriendlyByteBuf)packetBuffer, pos, player));
            return InteractionResult.SUCCESS;
        }).orElse((InteractionResult)InteractionResult.PASS);
    }

    public static boolean openContainerPartSettings(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderSettings(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiDataSettings((RegistryFriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static void openContainerAspectSettings(ServerPlayer player, PartPos pos, IAspect<?, ?> aspect) {
        player.openMenu(aspect.getPropertiesContainerProvider(pos), packetBuffer -> packetBuffer.writeUtf(aspect.getUniqueName().toString()));
    }

    public static boolean openContainerPartOffsets(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderOffsets(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiDataOffsets((RegistryFriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static Triple<IPartContainer, PartTypeBase, PartTarget> getContainerPartConstructionData(PartPos pos) {
        IPartContainer partContainer = PartHelpers.getPartContainer(pos.getPos(), pos.getSide()).orElse(null);
        if (partContainer == null) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The tile at %s is not a valid part container.", pos));
            return null;
        }
        IPartType partType = partContainer.getPart(pos.getSide());
        if (partType == null || !(partType instanceof PartTypeBase)) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part container at %s side %s does not have a valid part.", pos, pos.getSide()));
            return null;
        }
        PartTarget target = partType.getTarget(pos, partContainer.getPartState(pos.getSide()));
        return Triple.of((Object)partContainer, (Object)((PartTypeBase)partType), (Object)target);
    }

    public static PartTarget readPartTarget(RegistryFriendlyByteBuf packetBuffer) {
        return PartTarget.fromCenter((PartPos)PacketCodecs.read((RegistryFriendlyByteBuf)packetBuffer, PartPos.class));
    }

    public static <P extends IPartType<P, S>, S extends IPartState<P>> P readPart(FriendlyByteBuf packetBuffer) {
        String name = packetBuffer.readUtf();
        return (P)Objects.requireNonNull(PartTypeRegistry.getInstance().getPartType(ResourceLocation.parse((String)name)), String.format("Could not find a part by name %s", name));
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + String.valueOf(this.getPart()) + ", state=" + String.valueOf(this.getState()) + ")";
        }
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }
}

