/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadBlock {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockBooleanBlockTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.BOOLEAN_BLOCK, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockBooleanBlockFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.BOOLEAN_BLOCK, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockDimension(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.STRING_DIMENSION, ValueTypeString.ValueString.of(helper.getLevel().dimension().location().toString()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockPosX(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.INTEGER_POSX, ValueTypeInteger.ValueInteger.of(helper.absolutePos(POS.west()).getX()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockPosY(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.INTEGER_POSY, ValueTypeInteger.ValueInteger.of(helper.absolutePos(POS.west()).getY()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockPosZ(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.INTEGER_POSZ, ValueTypeInteger.ValueInteger.of(helper.absolutePos(POS.west()).getZ()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockBlock(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.BLOCK, ValueObjectTypeBlock.ValueBlock.of(Blocks.STONE.defaultBlockState()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockNbt(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        CompoundTag tag = helper.getBlockEntity(POS.west(), BlockEntity.class).saveWithFullMetadata((HolderLookup.Provider)helper.getLevel().registryAccess());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.NBT, ValueTypeNbt.ValueNbt.of((Tag)tag));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockBiome(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.STRING_DIMENSION, ValueTypeString.ValueString.of("minecraft:overworld"));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadBlockLight(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.BLOCK_READER, Aspects.Read.Block.INTEGER_LIGHT, ValueTypeInteger.ValueInteger.of(helper.getLevel().getMaxLocalRawBrightness(helper.absolutePos(POS.west()))));
    }
}

