/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;

public class GameTestsBattery {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testBatteryTransfer(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        BlockEntityEnergyBattery battery1 = (BlockEntityEnergyBattery)helper.getBlockEntity(POS, BlockEntityEnergyBattery.class);
        BlockEntityEnergyBattery battery2 = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.north(), BlockEntityEnergyBattery.class);
        battery1.setEnergyStored(100000);
        helper.setBlock(POS.south(), Blocks.REDSTONE_TORCH);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)battery1.getEnergyStored(), (Object)0, (Component)Component.literal((String)"Energy in battery 1 is not zero"));
            helper.assertValueEqual((Object)battery2.getEnergyStored(), (Object)100000, (Component)Component.literal((String)"Energy in battery 2 is not 5000"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testBatteryCombineEmpty(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_ENERGY_BATTERY.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)(BlockEnergyBatteryConfig.capacity * 2), (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE)), (Object)0, (Component)Component.literal((String)"Result item energy content is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testBatteryCombineFilled(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        crafter.getItem(0).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE, (Object)10000);
        crafter.getItem(1).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE, (Object)10000);
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_ENERGY_BATTERY.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)(BlockEnergyBatteryConfig.capacity * 2), (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE)), (Object)20000, (Component)Component.literal((String)"Result item energy content is incorrect"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testBatteryCombineFilledHigherCapacity(GameTestHelper helper) {
        helper.setBlock(POS, Blocks.CRAFTER);
        CrafterBlockEntity crafter = (CrafterBlockEntity)helper.getBlockEntity(POS, CrafterBlockEntity.class);
        helper.setBlock(POS.north(), Blocks.REDSTONE_TORCH);
        crafter.setItem(0, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        crafter.setItem(1, new ItemStack(RegistryEntries.ITEM_ENERGY_BATTERY));
        crafter.getItem(0).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY, (Object)(BlockEnergyBatteryConfig.capacity * 2));
        crafter.getItem(1).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY, (Object)(BlockEnergyBatteryConfig.capacity * 2));
        crafter.getItem(0).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE, (Object)10000);
        crafter.getItem(1).set((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE, (Object)10000);
        helper.succeedWhen(() -> {
            ItemStack result = ((ItemEntity)helper.findOneEntity(EntityType.ITEM)).getItem();
            helper.assertValueEqual((Object)result.getItem(), (Object)((Item)RegistryEntries.ITEM_ENERGY_BATTERY.get()), (Component)Component.literal((String)"Result item is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_CAPACITY)), (Object)(BlockEnergyBatteryConfig.capacity * 4), (Component)Component.literal((String)"Result item capacity is incorrect"));
            helper.assertValueEqual((Object)((Integer)result.get((Supplier)org.cyclops.cyclopscore.RegistryEntries.COMPONENT_ENERGY_STORAGE)), (Object)20000, (Component)Component.literal((String)"Result item energy content is incorrect"));
        });
    }
}

