/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalSqueezer;

public class GameTestsMechanicalSqueezer {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testMechanicalSqueezer(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.value());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.value());
        BlockEntityMechanicalSqueezer machine = (BlockEntityMechanicalSqueezer)helper.getBlockEntity(POS, BlockEntityMechanicalSqueezer.class);
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.north(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100000);
        machine.getInventory().setItem(0, new ItemStack((ItemLike)RegistryEntries.BLOCK_MENRIL_LOG.get()));
        helper.succeedWhen(() -> {
            helper.assertTrue(machine.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Machine did not consume input"));
            helper.assertValueEqual((Object)machine.getInventory().getItem(1).getItem(), (Object)((Item)RegistryEntries.ITEM_CRYSTALIZED_MENRIL_CHUNK.get()), (Component)Component.literal((String)"Machine did not produce item output"));
            helper.assertValueEqual((Object)machine.getTank().getFluid().getFluid(), (Object)((Fluid)RegistryEntries.FLUID_MENRIL_RESIN.get()), (Component)Component.literal((String)"Machine did not produce fluid output"));
            helper.assertTrue(battery.getEnergyStored() < 100000, (Component)Component.literal((String)"Energy in battery did not decrease"));
        });
    }
}

