/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntitySqueezer;

public class GameTestsSqueezer {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testSqueezer(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_SQUEEZER.value());
        BlockEntitySqueezer machine = (BlockEntitySqueezer)helper.getBlockEntity(POS, BlockEntitySqueezer.class);
        machine.getInventory().setItem(0, new ItemStack((ItemLike)RegistryEntries.BLOCK_MENRIL_LOG.get()));
        Wrapper entity = new Wrapper((Object)((Goat)helper.spawnWithNoFreeWill(EntityType.GOAT, POS.offset(0, 8, 0))));
        helper.runAfterDelay(20L, () -> {
            ((Goat)entity.get()).die(helper.getLevel().damageSources().generic());
            entity.set((Object)((Goat)helper.spawnWithNoFreeWill(EntityType.GOAT, POS.offset(0, 8, 0))));
        });
        helper.succeedWhen(() -> {
            helper.assertTrue(machine.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Machine did not consume input"));
            helper.assertValueEqual((Object)machine.getTank().getFluid().getFluid(), (Object)((Fluid)RegistryEntries.FLUID_MENRIL_RESIN.get()), (Component)Component.literal((String)"Machine did not produce fluid output"));
        });
    }
}

