/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.cyclops.cyclopscore.config.extendedconfig.ItemClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.client.model.ItemModelFacade;
import org.cyclops.integrateddynamics.item.ItemFacade;
import org.jetbrains.annotations.Nullable;

public class ItemFacadeConfigClient
extends ItemClientConfig<IntegratedDynamics> {
    public ItemFacadeConfigClient(ItemConfigCommon<IntegratedDynamics> itemConfig) {
        super(itemConfig);
        IntegratedDynamics._instance.getModEventBus().addListener(this::onRegisterColors);
        ((IntegratedDynamics)itemConfig.getMod()).getModEventBus().addListener(event -> event.register(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"facade"), ItemModelFacade.Unbaked.MAP_CODEC));
    }

    public void onRegisterColors(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(this.getItemConfig().getResourceKey().location(), Color.MAP_CODEC);
    }

    public static class Color
    implements ItemTintSource {
        public static final MapCodec<Color> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.point((Object)new Color()));

        public int calculate(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
            BlockState blockstate = ((ItemFacade)itemStack.getItem()).getFacadeBlock(itemStack);
            return Minecraft.getInstance().getBlockColors().getColor(blockstate, null, null);
        }

        public MapCodec<? extends ItemTintSource> type() {
            return MAP_CODEC;
        }
    }
}

